/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.exporter;

import com.arsdigita.categorization.Category;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.exporter.CategoryExporter;
import com.arsdigita.london.util.Transaction;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.web.Application;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CategoryExportTool
extends Program {
    boolean exportItems = false;

    public CategoryExportTool() {
        super("Category Export Tool", "1.0.1", "[app URL] [context] [export dir] [key] [url] [title] [version]");
        Options options = this.getOptions();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)"items");
        OptionBuilder.withDescription((String)"Export items/terms mappings");
        options.addOption(OptionBuilder.create((char)'i'));
    }

    public void doRun(CommandLine cmdLine) {
        File catDir;
        String[] args;
        if (cmdLine.hasOption('i')) {
            this.exportItems = true;
        }
        if ((args = cmdLine.getArgs()).length != 7) {
            for (int i = 0; i < args.length; ++i) {
                System.out.print("arg" + i + "='" + args[i] + "' ");
            }
            this.help(System.err);
            System.exit(1);
        }
        if (!(catDir = new File(args[2])).exists() && !catDir.mkdir()) {
            System.err.println("Could not mkdir " + catDir);
            return;
        }
        final String app = args[0];
        final String context = args[1];
        final String key = args[3];
        final String url = args[4];
        final String title = args[5];
        final String version = args[6];
        Transaction txn = new Transaction(){

            public void doRun() {
                Application appl = Application.retrieveApplicationForPath((String)app);
                Category root = "DEFAULT".equals(context) ? Category.getRootForObject((ACSObject)appl, null) : Category.getRootForObject((ACSObject)appl, (String)context);
                CategoryExporter catExporter = new CategoryExporter(catDir);
                try {
                    catExporter.export(root, key, new URI(url), title, null, version, new Date(), CategoryExportTool.this.exportItems);
                }
                catch (URISyntaxException ex) {
                    throw new UncheckedWrapperException("Cannot parse url " + url, (Throwable)ex);
                }
            }
        };
        txn.run();
    }

    public static void main(String[] args) {
        new CategoryExportTool().run(args);
    }
}

