/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.exporter;

import com.arsdigita.cms.Asset;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DomainObjectExporter
extends DomainObjectXMLRenderer {
    public static final Logger s_log = Logger.getLogger(DomainObjectExporter.class);
    private File m_assetDir;

    public DomainObjectExporter(Element root, File assetDir) {
        super(root);
        this.m_assetDir = assetDir;
    }

    public void handleAttribute(DomainObject obj, String path, Property property) {
        if ("global.Blob".equals(property.getType().getQualifiedName())) {
            String filename = this.getAssetFileName(obj, path, property);
            File file = new File(this.m_assetDir, filename);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Creating asset " + file + " for " + obj.getOID() + " " + path + " " + property.getName()));
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
            }
            catch (FileNotFoundException ex) {
                throw new UncheckedWrapperException("cannot open file " + file, (Throwable)ex);
            }
            byte[] bytes = (byte[])DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
            try {
                os.write(bytes);
                os.flush();
                os.close();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot write to file " + file, (Throwable)ex);
            }
            if (this.isWrappingAttributes()) {
                Element element = this.getCurrentElement().newChildElement(property.getName());
                element.addAttribute("file", filename);
            } else {
                this.getCurrentElement().addAttribute(property.getName(), filename);
            }
        } else {
            super.handleAttribute(obj, path, property);
        }
    }

    protected String getAssetFileName(DomainObject obj, String path, Property property) {
        Asset asset = (Asset)obj;
        return property.getName() + "-" + asset.getID() + "-" + asset.getName();
    }
}

