/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.cms.docmgr.ResourceExistsException;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.search.intermedia.Searchable;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DocLink
extends ContentPage
implements Resource,
Searchable {
    private static final Logger s_log = Logger.getLogger((String)DocLink.class.getName());
    private static final String NAME_SUFFIX = "-LinkTo";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.docmgr.DocLink";
    public static final String TYPE = "com.arsdigita.cms.docmgr.DocLink";
    public static final String DESCRIPTION = "description";
    private static final String REPOSITORY = "repository";
    private static final String TARGET = "target";
    private static final String EXTERNAL_URL = "externalURL";
    public static final String LAST_MOD_LOCAL = "lastModifiedTimeCached";

    public DocLink() {
        this("com.arsdigita.cms.docmgr.DocLink");
        try {
            this.setContentType(ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.docmgr.DocLink"));
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize((String)"cms.contenttypes.event_type_not_registered").localize(), (Throwable)e);
        }
    }

    public DocLink(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID("com.arsdigita.cms.docmgr.DocLink", (Object)id));
    }

    public DocLink(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public DocLink(DataObject obj) {
        super(obj);
    }

    public DocLink(String type) {
        super(type);
    }

    public void setTitle(String title) {
        this.setName(URLEncoder.encode(title));
        super.setTitle(title);
    }

    @Override
    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String desc) {
        this.set(DESCRIPTION, desc);
    }

    public boolean isExternal() {
        String s = this.getExternalURL();
        return s != null && s.length() > 0;
    }

    public String getExternalURL() {
        return (String)this.get(EXTERNAL_URL);
    }

    public void setExternalURL(String externalURL) {
        this.set(EXTERNAL_URL, externalURL);
    }

    public Repository getRepository() {
        if (this.get(REPOSITORY) == null) {
            return null;
        }
        return new Repository((DataObject)this.get(REPOSITORY));
    }

    public void setRepository(Repository repository) {
        this.set(REPOSITORY, (Object)repository);
    }

    public Date getLastModifiedLocal() {
        return (Date)this.get(LAST_MOD_LOCAL);
    }

    public void setLastModifiedLocal(Date last) {
        this.set(LAST_MOD_LOCAL, last);
    }

    public void setTarget(Document target) {
        this.setName(this.generateLinkName(target));
        this.set(TARGET, target);
    }

    private String generateLinkName(Document targetDoc) {
        StringBuffer buf = new StringBuffer(targetDoc.getName());
        buf.append(NAME_SUFFIX).append(targetDoc.getID());
        if (buf.length() > 200) {
            String docName = targetDoc.getName();
            String suffix = NAME_SUFFIX + targetDoc.getID();
            int suffixLen = suffix.length();
            docName = docName.substring(0, 200 - suffixLen);
            Assert.isTrue(((docName = docName + suffix).length() < 201 ? 1 : 0) != 0, (String)("Actual Length is: " + docName.length()));
            return docName;
        }
        return buf.toString();
    }

    public Document getTarget() {
        if (this.get(TARGET) == null) {
            return null;
        }
        return new Document((DataObject)this.get(TARGET));
    }

    @Override
    public Resource getParentResource() {
        DocFolder parent = (DocFolder)((ContentBundle)this.getParent()).getParent();
        return parent;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public Resource copyTo(Resource parent) throws ResourceExistsException {
        return this.copyTo(this.getTitle(), parent);
    }

    @Override
    public Resource copyTo(String name, final Resource parent) throws ResourceExistsException {
        Folder.ItemCollection ic = ((Folder)parent).getItems();
        ic.addEqualsFilter("name", (Object)URLEncoder.encode(name));
        boolean resourceExists = ic.next();
        ic.close();
        if (resourceExists) {
            throw new ResourceExistsException("Copying document would result in duplicate: " + name);
        }
        DocLink item = this;
        if (item.getParent() instanceof ContentBundle) {
            item = (ContentBundle)item.getParent();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying item " + item));
        }
        final ContentItem newItem = item.copy();
        newItem.copyServicesFrom((ContentItem)item);
        newItem.setParent((ACSObject)((Folder)parent));
        newItem.setContentSection(item.getContentSection());
        newItem.save();
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.setContext((ACSObject)newItem, (ACSObject)((ACSObject)parent));
            }
        }.run();
        return (Resource)((ContentBundle)newItem).getPrimaryInstance();
    }

    @Override
    public Resource copyTo(String name) throws ResourceExistsException {
        ACSObject parent = this.getParent();
        return this.copyTo(name, (Resource)parent);
    }

    @Override
    public URL toURL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParentResource(final Resource parent) {
        final ContentBundle cb = (ContentBundle)this.getParent();
        cb.setParent((ACSObject)parent);
        cb.save();
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.setContext((ACSObject)cb, (ACSObject)((ACSObject)parent));
            }
        }.run();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void delete() throws PersistenceException {
        ((ContentBundle)this.getParent()).delete();
    }

    public String getSearchXMLContent() {
        return "";
    }

    public byte[] getSearchRawContent() {
        return new byte[0];
    }

    public void setCategories(String[] catIDs) {
        CategoryCollection cats;
        HashSet<String> newCategories = new HashSet<String>();
        if (catIDs != null) {
            for (int i = 0; i < catIDs.length; ++i) {
                newCategories.add(catIDs[i]);
                s_log.debug((Object)("newCategories: " + catIDs[i]));
            }
        }
        if ((cats = this.getCategoryCollection()).next()) {
            Category cat = cats.getCategory();
            String catID = cat.getID().toString();
            if (newCategories.contains(catID)) {
                newCategories.remove(catID);
            } else {
                this.removeCategory(cat);
            }
        }
        Iterator additions = newCategories.iterator();
        while (additions.hasNext()) {
            this.addCategory(new Category(new BigDecimal((String)additions.next())));
        }
    }

    protected void beforeSave() {
        super.beforeSave();
        this.setLastModifiedLocal(new Date());
    }

    public String getSearchLanguage() {
        return "eng";
    }

    public String getSearchLinkText() {
        return this.generateLinkName(this.getTarget());
    }

    public String getSearchUrlStub() {
        return "";
    }
}

