/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.DocumentCollection;
import com.arsdigita.cms.docmgr.Resource;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Repository
extends Application {
    private static Logger s_log = Logger.getLogger(Repository.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.docmgr.Repository";
    public static final String OWNER = "ownerID";
    public static final String ROOT = "rootID";
    private DocFolder m_root = null;
    private static String s_repositoryRoot = null;
    private boolean m_wasNew;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Repository(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Repository(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Repository(DataObject obj) {
        super(obj);
        if (obj.isNew()) {
            s_log.info((Object)"Create root folder for repository");
            ContentSectionCollection csl = ContentSection.getAllSections();
            csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
            if (!csl.next()) {
                s_log.fatal((Object)("could not retrive section: " + DocMgr.getConfig().getContentSection()));
                csl.close();
                return;
            }
            final ContentSection cs = csl.getContentSection();
            csl.close();
            this.m_root = new DocFolder();
            KernelExcursion excursion = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    Assert.exists((Object)Repository.this.m_root, (String)"Folder m_root");
                    if (s_repositoryRoot == null) {
                        Repository.this.m_root.setParent((ACSObject)cs.getRootFolder());
                        s_log.debug((Object)"typical repository (no legacy folder)");
                    } else {
                        Repository.this.m_root.setParent((ACSObject)cs.getRootFolder().getItem(DocMgr.getConfig().getLegacyFolderName(), true));
                        s_log.debug((Object)("legacy folder, using folder: " + DocMgr.getConfig().getLegacyFolderName()));
                    }
                    PermissionService.setContext((ACSObject)Repository.this.m_root, (ACSObject)Repository.this);
                }
            };
            excursion.run();
            this.m_root.setName(this.getID().toString());
            this.m_root.setLabel("root folder for repository: " + this.getID().toString());
            obj.set(ROOT, (Object)this.m_root.getID());
            this.m_root.save();
            s_log.info((Object)("Created root folder for repository " + this.getID()));
        }
    }

    protected void beforeSave() {
        if (this.isNew()) {
            this.m_wasNew = true;
        }
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        s_log.debug((Object)"aftersave");
        if (this.m_wasNew) {
            s_log.debug((Object)"aftersave new");
            final Repository rep = this;
            KernelExcursion excursion = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    Assert.exists((Object)Repository.this.m_root, (String)"Folder m_root");
                    PermissionService.setContext((ACSObject)Repository.this.m_root, (ACSObject)rep);
                    s_log.debug((Object)("set context for " + Repository.this.m_root.getTitle()));
                    s_log.debug((Object)("  parent is " + rep.getID().toString()));
                }
            };
            excursion.run();
        }
    }

    public static Repository create(String urlName, String title, Application parent) {
        Repository repository = (Repository)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        s_log.debug((Object)"create");
        return repository;
    }

    public static void setRepositoryRoot(String folderName) {
        s_repositoryRoot = folderName;
    }

    private void setName(String name) {
        this.set("name", name);
    }

    private void setOwner(BigDecimal ownerID) {
        this.set(OWNER, ownerID);
    }

    public static Resource retrieveResource(String absPath) {
        throw new UnsupportedOperationException();
    }

    private static void assertParty(Party party) {
        BigDecimal id = party.getID();
        if (id == null) {
            throw new RuntimeException("User not peristent");
        }
    }

    public Party getOwner() {
        BigDecimal id = (BigDecimal)this.get(OWNER);
        User party = null;
        if (id != null) {
            try {
                party = User.retrieve((BigDecimal)id);
            }
            catch (DataObjectNotFoundException e1) {
                try {
                    party = new Group(id);
                }
                catch (DataObjectNotFoundException e2) {
                    throw new RuntimeException("No User or Group found.");
                }
            }
        }
        return party;
    }

    public DocFolder getRoot() {
        BigDecimal id = (BigDecimal)this.get(ROOT);
        DocFolder root = null;
        try {
            root = new DocFolder(id);
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException("Repository root folder does not exist");
        }
        return root;
    }

    public void setLegacyRoot() {
        ContentSectionCollection csl = ContentSection.getAllSections();
        csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
        if (!csl.next()) {
            s_log.fatal((Object)("could not retrive section: " + DocMgr.getConfig().getContentSection()));
            csl.close();
        }
        ContentSection cs = csl.getContentSection();
        csl.close();
        this.m_root = new DocFolder();
        DocFolder oldRoot = this.getRoot();
        this.m_root.setParent((ACSObject)cs.getRootFolder().getItem(DocMgr.getConfig().getLegacyFolderName(), true));
        s_log.debug((Object)("setLegacyRoot, using folder: " + DocMgr.getConfig().getLegacyFolderName()));
        if (oldRoot != null) {
            oldRoot.delete();
        }
        this.m_root.setName(this.getID().toString());
        this.m_root.setLabel("root folder for repository: " + this.getID().toString());
        this.m_root.save();
        this.set(ROOT, this.m_root.getID());
    }

    public static DocumentCollection getRecentlyModifiedDocuments() {
        HttpServletRequest req = Web.getRequest();
        Repository rep = Repository.getCurrentRepository(req);
        return Repository.getRecentlyModifiedDocuments(rep);
    }

    public static DocumentCollection getRecentlyModifiedDocuments(Repository rep) {
        DataCollection dataCollection = SessionManager.getSession().retrieve("com.arsdigita.cms.docmgr.Document");
        dataCollection.addFilter(dataCollection.getFilterFactory().contains("ancestors", "/" + rep.getRoot().getID().toString() + "/", false));
        DocumentCollection rCollection = new DocumentCollection(dataCollection);
        return rCollection;
    }

    public static Repository getCurrentRepository(HttpServletRequest req) {
        Application app = Application.getCurrentApplication((HttpServletRequest)req);
        if (app instanceof Repository) {
            return (Repository)app;
        }
        return null;
    }

    public String getServletPath() {
        return "/docmgr-repo";
    }
}

