/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.dispatcher;

import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DocumentAssetPage
extends CMSPage {
    private static final Logger s_log = Logger.getLogger(DocumentAssetPage.class);
    public static final String ASSET_ID = "asset_id";
    private BigDecimalParameter m_asset_id = new BigDecimalParameter("asset_id");

    public DocumentAssetPage() {
        this.m_asset_id.addParameterListener((ParameterListener)new NotNullValidationListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        ContentItem item = CMS.getContext().getContentItem();
        Document doc = null;
        try {
            doc = (Document)DomainObjectFactory.newInstance((OID)item.getOID());
        }
        catch (DataObjectNotFoundException e) {
            s_log.error((Object)("Data Object Not Found for id " + item.getOID()), (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        Assert.isTrue((boolean)(doc instanceof Document), (String)("document is not a document" + doc.getID().toString()));
        FileAsset docAsset = doc.getFile();
        Assert.exists((Object)docAsset, FileAsset.class);
        MimeType mime = docAsset.getMimeType();
        if (mime == null) {
            throw new ServletException("Could not fetch MIME type of document: " + docAsset.getID().toString());
        }
        response.setContentType(mime.getMimeType());
        ServletOutputStream out = response.getOutputStream();
        try {
            docAsset.writeBytes((OutputStream)out);
        }
        finally {
            out.close();
        }
    }
}

