/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.ui.CategoryDocModelBuilder;
import com.arsdigita.cms.docmgr.ui.CategoryDocsNavigatorPortlet;
import com.arsdigita.cms.docmgr.ui.CategoryItemsBrowser;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DestinationFolderForm;
import com.arsdigita.cms.docmgr.ui.SearchPane;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.navigation.ui.admin.CategorySelectionModel;
import com.arsdigita.navigation.ui.admin.CategoryTree;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Category;

class BrowseCatDocsPane
extends ModalContainer
implements DMConstants,
ChangeListener,
RequestListener {
    protected static Category s_log = Category.getInstance((String)CategoryDocsNavigatorPortlet.class.getName());
    private Component m_folderContent;
    private Component m_destinationFolderPanel;
    private Component m_newFileForm;
    private Component m_newFolderForm;
    private Component m_errorMsgPanel;
    private DestinationFolderForm m_destinationFolderForm;
    private ErrorMessageLabel m_errorMsgLabel;
    private Container m_mainBrowseContainer;
    private ContentSection m_docsContentSection;
    private TabbedPane m_mainTabPane;
    private CategoryTree m_tree;
    private BigDecimalParameter m_docCategoryTreeParam = new BigDecimalParameter("dct_id");
    private BigDecimalParameter m_docInitCategoryTreeParam = new BigDecimalParameter("dct_init_id");
    private BigDecimalParameter m_fileIdParam = new BigDecimalParameter("d_id");
    private StringParameter m_rootAddDocParam = new StringParameter("root_add_doc");
    private final DateParameter m_startDateParam = new DateParameter("startDate");
    private final DateParameter m_endDateParam = new DateParameter("endDate");
    private ACSObjectSelectionModel m_docCatSelectModel;

    public BrowseCatDocsPane() {
        this.m_mainTabPane = new TabbedPane();
        this.m_mainBrowseContainer = new BoxPanel();
        this.m_mainTabPane.addTab((Component)WS_BROWSE_TITLE, (Component)this.m_mainBrowseContainer);
        this.m_mainTabPane.addTab("Search", (Component)new SearchPane());
        this.m_mainBrowseContainer.setClassAttr("sidebarNavPanel");
        ContentSectionCollection csl = ContentSection.getAllSections();
        csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
        if (!csl.next()) {
            csl.close();
            return;
        }
        this.m_docsContentSection = csl.getContentSection();
        csl.close();
        s_log.debug((Object)("m_docs section is " + this.m_docsContentSection.getName()));
        this.m_docCatSelectModel = new ACSObjectSelectionModel(this.m_docCategoryTreeParam);
        CategorySelectionModel m_categorySelectionModel = new CategorySelectionModel();
        this.m_tree = new CategoryTree(m_categorySelectionModel);
        s_log.debug((Object)"added category tree");
        if (this.m_tree == null) {
            s_log.debug((Object)" but the tree was null");
        }
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        this.m_tree.addChangeListener((ChangeListener)this);
        leftSide.add((Component)this.m_tree);
        this.m_mainBrowseContainer.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_folderContent = this.makeContentPanel(rightSide);
        this.m_mainBrowseContainer.add((Component)rightSide);
        this.add((Component)this.m_mainTabPane);
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)this.m_rootAddDocParam);
        p.addGlobalStateParam((ParameterModel)this.m_fileIdParam);
        p.addGlobalStateParam((ParameterModel)this.m_docCategoryTreeParam);
        p.addGlobalStateParam((ParameterModel)this.m_docInitCategoryTreeParam);
        p.addGlobalStateParam((ParameterModel)this.m_endDateParam);
        p.addGlobalStateParam((ParameterModel)this.m_startDateParam);
        p.addRequestListener((RequestListener)this);
        super.register(p);
    }

    public void pageRequested(RequestEvent e) {
        PageState state = e.getPageState();
        if (this.m_tree == null) {
            s_log.debug((Object)"pR: tree is null");
            return;
        }
        BigDecimal key = (BigDecimal)this.m_tree.getSelectedKey(state);
        if (key == null) {
            s_log.debug((Object)"key is null");
            BigDecimal selected = (BigDecimal)this.m_docInitCategoryTreeParam.transformValue(state.getRequest());
            BigDecimal rootCategoryID = this.m_docsContentSection.getRootCategory().getID();
            if (selected == null) {
                s_log.debug((Object)"selected is null");
                key = rootCategoryID;
                this.m_tree.expand(rootCategoryID.toString(), state);
            } else {
                key = selected;
                this.m_tree.expand(rootCategoryID.toString(), state);
            }
            this.m_tree.setSelectedKey(state, (Object)key);
        }
    }

    public BigDecimal getFolderID(PageState state) {
        return (BigDecimal)this.m_tree.getSelectedKey(state);
    }

    public void stateChanged(ChangeEvent e) {
        PageState state = e.getPageState();
        s_log.debug((Object)"stateChanged yo");
        this.displayFolderContentPanel(state);
    }

    private Component makeContentPanel(SegmentedPanel main) {
        Label info_header = new Label(new GlobalizedMessage("ui.cat.browse.content.header", "com.arsdigita.cms.docmgr.ui.DMResources"));
        GridPanel folderGrid = new GridPanel(1);
        SimpleContainer pane = new SimpleContainer();
        pane.add((Component)new Label("        "));
        folderGrid.add((Component)pane, 36);
        CategoryItemsBrowser documentsTable = new CategoryItemsBrowser(new CategoryDocModelBuilder(this.m_docCatSelectModel, "draft"), this.m_docCatSelectModel, "draft", this.m_docsContentSection);
        Paginator paginator = new Paginator((PaginationModelBuilder)documentsTable, 10);
        documentsTable.setPaginator(paginator);
        folderGrid.add((Component)paginator);
        folderGrid.add((Component)documentsTable, 33);
        folderGrid.add((Component)new Label("        "), 36);
        folderGrid.add((Component)new DateSelectorWidget((Container)new BoxPanel(1)), 34);
        return main.addSegment((Component)info_header, (Component)folderGrid);
    }

    private Component makeErrorMsgPanel() {
        ColumnPanel c = new ColumnPanel(1);
        this.m_errorMsgLabel = new ErrorMessageLabel();
        c.add((Component)this.m_errorMsgLabel);
        ActionLink link = new ActionLink((Component)ACTION_ERROR_CONTINUE);
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowseCatDocsPane.this.displayFolderContentPanel(e.getPageState());
            }
        });
        c.add((Component)link);
        return c;
    }

    public void displayFolderContentPanel(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_mainTabPane);
    }

    public void displayErrorMsgPanel(PageState state, String action, ArrayList list) {
        this.m_errorMsgLabel.setMessages(state, action, list);
        this.setVisibleComponent(state, this.m_errorMsgPanel);
    }

    private class DateSelectorWidget
    extends Form {
        public DateSelectorWidget(Container panel) {
            super("dateSelector", panel);
            this.add((Component)new Label("Modified After: "));
            this.add((Component)new Date((ParameterModel)BrowseCatDocsPane.this.m_startDateParam));
            this.add((Component)new Label("Modified Before: "));
            this.add((Component)new Date((ParameterModel)BrowseCatDocsPane.this.m_endDateParam));
            this.add((Component)new Submit("filter", "Filter"));
        }
    }

    private static class DirLinkRenderer
    implements ListCellRenderer {
        private DirLinkRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            Link link = new Link((String)value, "?" + DMConstants.SEL_FOLDER_ID_PARAM.getName() + "=" + key);
            return link;
        }
    }

    private static class ErrorMessageLabel
    extends SimpleComponent
    implements DMConstants {
        private RequestLocal m_msgs = new RequestLocal();
        private RequestLocal m_action = new RequestLocal();

        public void setMessages(PageState state, String action, ArrayList msgs) {
            this.m_action.set(state, (Object)action);
            this.m_msgs.set(state, (Object)msgs);
        }

        public void generateXML(PageState state, Element parent) {
            Element element = parent.newChildElement("docs:error-label", "http://www.redhat.com/docs/1.0");
            element.addAttribute("action", (String)this.m_action.get(state));
            ArrayList list = (ArrayList)this.m_msgs.get(state);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Element item = element.newChildElement("docs:item", "http://www.redhat.com/docs/1.0");
                    item.addAttribute("name", (String)list.get(i));
                }
            }
        }
    }
}

