/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.FileInfoPropertiesPane;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

class FileActionPane
extends ColumnPanel
implements DMConstants,
RequestListener {
    private FileInfoPropertiesPane m_parent;
    private ActionLink m_newVersion;
    private Link m_download;
    private ActionLink m_email;
    private ActionLink m_delete;
    private static final Logger s_log = Logger.getLogger(FileActionPane.class);

    FileActionPane(FileInfoPropertiesPane parent) {
        super(1);
        this.m_parent = parent;
        this.m_newVersion = this.addActionLink(FILE_NEW_VERSION_LINK);
        PrintListener printListener = new PrintListener(){

            public void prepare(PrintEvent e) {
                Link l = (Link)e.getTarget();
                PageState state = e.getPageState();
                Document f = FileActionPane.this.m_parent.getDocument(state);
                l.setTarget("download/" + f.getName() + "?" + "d_id" + "=" + f.getID());
            }
        };
        this.m_download = new Link((Component)new Label(FILE_DOWNLOAD_LINK), printListener);
        this.m_download.setClassAttr("actionLink");
        this.add((Component)this.m_download);
        this.m_email = this.addActionLink(FILE_SEND_COLLEAGUE_LINK);
        this.m_delete = this.addActionLink(FILE_DELETE_LINK);
        this.m_newVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileActionPane.this.m_parent.displayUploadForm(e.getPageState());
            }
        });
        this.m_email.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileActionPane.this.m_parent.displaySendColleagueForm(e.getPageState());
            }
        });
        this.m_delete.addActionListener((ActionListener)new DeleteListener());
        this.m_delete.setConfirmation(FILE_DELETE_CONFIRM.localize().toString());
    }

    private ActionLink addActionLink(GlobalizedMessage msg) {
        ActionLink ln = new ActionLink((Component)new Label(msg));
        ln.setClassAttr("actionLink");
        this.add((Component)ln);
        return ln;
    }

    public void pageRequested(RequestEvent event) {
        PageState state = event.getPageState();
        s_log.debug((Object)"pageRequested");
        if (!this.isVisible(state)) {
            return;
        }
        User user = Web.getContext().getUser();
        Document doc = this.m_parent.getDocument(state);
        if (PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)doc, (Party)user))) {
            return;
        }
        this.m_delete.setVisible(state, false);
        if (!PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.WRITE, (ACSObject)doc, (Party)user))) {
            this.m_newVersion.setVisible(state, false);
        }
    }

    private final class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            Document doc = FileActionPane.this.m_parent.getDocument(state);
            ContentBundle cb = (ContentBundle)doc.getParent();
            String parentFolderID = cb.getParent().getID().toString();
            cb.delete();
            try {
                String appURI = this.getRedirectURI(state);
                DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)(appURI + "?" + DMConstants.SEL_FOLDER_ID_PARAM.getName() + "=" + parentFolderID));
            }
            catch (IOException iox) {
                throw new UncheckedWrapperException((Throwable)iox);
            }
        }

        private String getRedirectURI(PageState state) {
            String appURI = state.getRequestURI();
            s_log.debug((Object)("Original app URI: " + appURI));
            int idx = appURI.indexOf("/file/");
            appURI = appURI.substring(0, idx);
            String servletPath = Web.getConfig().getDispatcherServletPath();
            if (appURI.startsWith(servletPath)) {
                appURI = appURI.substring(servletPath.length());
            }
            s_log.debug((Object)("New URI: " + appURI));
            return appURI;
        }
    }
}

