/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.docmgr.search.SearchResult;
import org.apache.log4j.Logger;

public class SearchList
extends List {
    private static final Logger s_log = Logger.getLogger(SearchList.class);

    public SearchList(ListModelBuilder model) {
        this.setModelBuilder(model);
        this.setCellRenderer(new SearchResultRenderer());
    }

    public static class SearchResultRenderer
    implements ListCellRenderer {
        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            SearchResult res = (SearchResult)value;
            return new SearchResultDisplay(res);
        }
    }

    public static class SearchResultDisplay
    extends SimpleContainer {
        private ExternalLink m_title;
        private Label m_score;
        private Label m_summary;

        public SearchResultDisplay(SearchResult result) {
            if (result != null) {
                String url = result.getUrlStub();
                this.m_title = new ExternalLink(result.getLink(), url);
                this.add((Component)this.m_title);
                String score = result.getScore().toString();
                if (score.length() > 5) {
                    score = score.substring(0, 5);
                }
                this.m_score = new Label(" (score: " + score + ") ");
                this.m_score.setClassAttr("score");
                this.add((Component)this.m_score);
                String summary = result.getSummary();
                if (null != summary) {
                    this.m_summary = new Label(summary, false);
                    this.m_summary.setClassAttr("summary");
                    this.add((Component)this.m_summary);
                }
            }
            this.setClassAttr("searchResult");
        }
    }
}

