/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.docmgr.DocMgr;
import com.arsdigita.cms.docmgr.search.LuceneSearcher;
import com.arsdigita.cms.docmgr.search.SearchResults;
import com.arsdigita.cms.docmgr.search.SearchUtils;
import com.arsdigita.cms.docmgr.ui.CategoriesPrintListener;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.SearchForm;
import com.arsdigita.cms.docmgr.ui.SearchList;
import com.arsdigita.cms.docmgr.ui.SearchListModelBuilder;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class SearchPane
extends SimpleContainer
implements DMConstants {
    private static final Logger s_log = Logger.getLogger(SearchPane.class);
    public static final String SEARCH_AUTHOR = "searchAuthor";
    public static final String SEARCH_TERMS = "searchTerms";
    public static final String SEARCH_MIME_TYPE = "searchMimeType";
    public static final String CATEGORY_SELECT = "searchCategorySelect";
    public static final String WORKSPACE_SELECT = "workspaceSelect";
    private final BigDecimalParameter m_categoriesParam = new BigDecimalParameter("searchCategorySelect");
    private final BigDecimalParameter m_workspaceParam = new BigDecimalParameter("workspaceSelect");
    private final TrimmedStringParameter m_termsParam = new TrimmedStringParameter("searchTerms");
    private final TrimmedStringParameter m_authorParam = new TrimmedStringParameter("searchAuthor");
    private final StringParameter m_mimeTypeParam = new StringParameter("searchMimeType");
    private final DateParameter m_startDateParam = new DateParameter("startDate");
    private final DateParameter m_endDateParam = new DateParameter("endDate");
    private ContentSection m_docsContentSection;
    private RequestLocal m_coln;
    private RequestLocal m_validated;
    private BoxPanel m_mainBrowseContainer;
    private Table m_searchResultsTable;
    private SearchList m_searchList;
    private SearchListModelBuilder m_model;
    private Label m_noResultsLabel;
    private Label m_hasResultsLabel;
    private Label m_emptyLabel;
    private Submit m_submit;
    private ModalContainer m_segmentHeader;

    public SearchPane() {
        ContentSectionCollection csl = ContentSection.getAllSections();
        csl.addEqualsFilter("label", (Object)DocMgr.getConfig().getContentSection());
        if (!csl.next()) {
            csl.close();
            return;
        }
        this.m_docsContentSection = csl.getContentSection();
        csl.close();
        this.m_mainBrowseContainer = new BoxPanel(1, true);
        DocsSearchForm leftSide = new DocsSearchForm((Container)new GridPanel(2));
        this.m_mainBrowseContainer.add((Component)leftSide);
        this.m_mainBrowseContainer.add((Component)new Label(" &nbsp; &nbsp; ", false));
        this.m_model = new SearchListModelBuilder(leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_searchList = new SearchList((ListModelBuilder)this.m_model);
        this.m_segmentHeader = new ModalContainer();
        this.m_hasResultsLabel = new Label("Results");
        this.m_noResultsLabel = new Label("No results matched your search");
        this.m_emptyLabel = new Label("");
        this.m_segmentHeader.add((Component)this.m_hasResultsLabel);
        this.m_segmentHeader.add((Component)this.m_noResultsLabel);
        this.m_segmentHeader.add((Component)this.m_emptyLabel);
        this.m_segmentHeader.setDefaultComponent((Component)this.m_emptyLabel);
        rightSide.addSegment((Component)this.m_segmentHeader, (Component)this.m_searchList);
        this.m_mainBrowseContainer.add((Component)rightSide);
        this.m_coln = new RequestLocal();
        this.m_validated = new RequestLocal();
        this.add((Component)this.m_mainBrowseContainer);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_categoriesParam);
        p.addGlobalStateParam((ParameterModel)this.m_workspaceParam);
        p.addGlobalStateParam((ParameterModel)this.m_termsParam);
        p.addGlobalStateParam((ParameterModel)this.m_authorParam);
        p.addGlobalStateParam((ParameterModel)this.m_mimeTypeParam);
        p.addGlobalStateParam((ParameterModel)this.m_endDateParam);
        p.addGlobalStateParam((ParameterModel)this.m_startDateParam);
    }

    private class WorkspacesPrintListener
    implements PrintListener {
        public void prepare(PrintEvent e) {
            OptionGroup o = (OptionGroup)e.getTarget();
            PageState state = e.getPageState();
            User user = Web.getContext().getUser();
            o.addOption(new Option("", ""));
            DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.docmgr.workspacesWithRepositories");
            while (dq.next()) {
                if (PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, new OID("com.arsdigita.cms.docmgr.Document", dq.get("workspaceID")), user.getOID()))) {
                    o.addOption(new Option(((BigDecimal)dq.get("workspaceID")).toString(), (String)dq.get("title")));
                }
                dq.close();
            }
        }
    }

    private class MimeTypesWidget
    extends SingleSelect {
        public MimeTypesWidget(ParameterModel pm) {
            super(pm);
            this.addOption(new Option("", ""));
            this.addOption(new Option("excel", "Excel document"));
            this.addOption(new Option("html", "HTML"));
            this.addOption(new Option("acrobat", "PDF"));
            this.addOption(new Option("plain text", "Plain text"));
            this.addOption(new Option("powerpoint", "Powerpoint file"));
            this.addOption(new Option("rich text", "Rich Text Format (rtf)"));
            this.addOption(new Option("word", "Word document"));
        }
    }

    private class DocsSearchForm
    extends Form
    implements SearchForm,
    FormValidationListener,
    FormProcessListener,
    FormInitListener {
        public DocsSearchForm(Container panel) {
            super("docSearch", panel);
            this.add((Component)new Label("Search text:"));
            TextField searchText = new TextField(SearchPane.SEARCH_TERMS);
            this.add((Component)searchText);
            this.add((Component)new Label("Author:"));
            this.add((Component)new TextField(SearchPane.SEARCH_AUTHOR));
            this.add((Component)new Label("Document Type:"));
            this.add((Component)new MimeTypesWidget((ParameterModel)SearchPane.this.m_mimeTypeParam));
            this.add((Component)new Label("Modified After: "));
            this.add((Component)new Date((ParameterModel)SearchPane.this.m_startDateParam));
            this.add((Component)new Label("Modified Before: "));
            this.add((Component)new Date((ParameterModel)SearchPane.this.m_endDateParam));
            this.add((Component)new Label("Category"));
            SingleSelect categoriesWidget = new SingleSelect((ParameterModel)SearchPane.this.m_categoriesParam);
            try {
                categoriesWidget.addOption(new Option("", ""));
                categoriesWidget.addPrintListener((PrintListener)new CategoriesPrintListener(SearchPane.this.m_docsContentSection));
            }
            catch (TooManyListenersException e) {
                UncheckedWrapperException.throwLoggedException(this.getClass(), (String)"Too many listeners", (Throwable)e);
            }
            this.add((Component)categoriesWidget);
            this.add((Component)new Label("Workspace"));
            SingleSelect workspaceWidget = new SingleSelect((ParameterModel)SearchPane.this.m_workspaceParam);
            try {
                workspaceWidget.addPrintListener((PrintListener)new WorkspacesPrintListener());
            }
            catch (TooManyListenersException e) {
                UncheckedWrapperException.throwLoggedException(this.getClass(), (String)"Too many listeners", (Throwable)e);
            }
            this.add((Component)workspaceWidget);
            SearchPane.this.m_submit = new Submit("search", "Search");
            this.add((Component)SearchPane.this.m_submit);
            this.addInitListener(this);
            this.addValidationListener(this);
            this.addProcessListener(this);
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            String terms = (String)state.getValue((ParameterModel)SearchPane.this.m_termsParam);
            String author = (String)state.getValue((ParameterModel)SearchPane.this.m_authorParam);
            String mimeType = (String)state.getValue((ParameterModel)SearchPane.this.m_mimeTypeParam);
            java.util.Date endDate = (java.util.Date)state.getValue((ParameterModel)SearchPane.this.m_endDateParam);
            java.util.Date startDate = (java.util.Date)state.getValue((ParameterModel)SearchPane.this.m_startDateParam);
            BigDecimal workspaceID = (BigDecimal)state.getValue((ParameterModel)SearchPane.this.m_workspaceParam);
            BigDecimal categoryID = (BigDecimal)state.getValue((ParameterModel)SearchPane.this.m_categoriesParam);
            if (StringUtils.emptyString((String)terms) && StringUtils.emptyString((String)author) && StringUtils.emptyString((String)mimeType) && endDate == null && startDate == null && categoryID == null && workspaceID == null) {
                SearchPane.this.m_emptyLabel.setVisible(state, true);
                SearchPane.this.m_validated.set(state, (Object)new Boolean(false));
                throw new FormProcessException("At least one search parameter must be specified");
            }
            SearchPane.this.m_validated.set(state, (Object)new Boolean(true));
        }

        public void init(FormSectionEvent e) {
            SearchPane.this.m_segmentHeader.setVisibleComponent(e.getPageState(), (Component)SearchPane.this.m_emptyLabel);
        }

        public void process(FormSectionEvent e) {
            PageState state = e.getPageState();
            SearchResults results = this.getSearchHits(state);
            if (results != null && results.getTotalSize() > 0L) {
                SearchPane.this.m_segmentHeader.setVisibleComponent(state, (Component)SearchPane.this.m_hasResultsLabel);
                s_log.debug((Object)"results");
            } else {
                SearchPane.this.m_segmentHeader.setVisibleComponent(state, (Component)SearchPane.this.m_noResultsLabel);
                s_log.debug((Object)"no results");
            }
        }

        @Override
        public SearchResults getSearchHits(PageState state) {
            SearchResults coln = (SearchResults)SearchPane.this.m_coln.get(state);
            if (coln == null && SearchPane.this.m_submit.isSelected(state) && ((Boolean)SearchPane.this.m_validated.get(state)).booleanValue()) {
                BigDecimal categoryID;
                String terms = (String)state.getValue((ParameterModel)SearchPane.this.m_termsParam);
                String author = (String)state.getValue((ParameterModel)SearchPane.this.m_authorParam);
                String mimeType = (String)state.getValue((ParameterModel)SearchPane.this.m_mimeTypeParam);
                java.util.Date endDate = (java.util.Date)state.getValue((ParameterModel)SearchPane.this.m_endDateParam);
                java.util.Date startDate = (java.util.Date)state.getValue((ParameterModel)SearchPane.this.m_startDateParam);
                BigDecimal workspaceID = (BigDecimal)state.getValue((ParameterModel)SearchPane.this.m_workspaceParam);
                String[] sections = null;
                if (!LuceneSearcher.class.equals(SearchUtils.getSearcher().getClass())) {
                    sections = new String[]{SearchPane.this.m_docsContentSection.getID().toString()};
                }
                String[] types = null;
                BigDecimal rootCategoryID = SearchPane.this.m_docsContentSection.getRootCategory().getID();
                ArrayList<String> categoryIDs = new ArrayList<String>();
                if (!LuceneSearcher.class.equals(SearchUtils.getSearcher().getClass()) && (categoryID = (BigDecimal)state.getValue((ParameterModel)SearchPane.this.m_categoriesParam)) != null && !categoryID.equals(rootCategoryID)) {
                    categoryIDs.add(categoryID.toString());
                }
                User user = KernelHelper.getCurrentUser((HttpServletRequest)state.getRequest());
                coln = SearchUtils.getAdvancedSearch(terms, author, mimeType, workspaceID, startDate, endDate, types, sections, user, categoryIDs);
                SearchPane.this.m_coln.set(state, (Object)coln);
            }
            return coln;
        }

        @Override
        public boolean isVisible(PageState state) {
            return true;
        }

        @Override
        public long getSearchResultCount(PageState state) {
            return SearchPane.this.m_coln.get(state) == null ? 0L : ((SearchResults)SearchPane.this.m_coln.get(state)).getTotalSize();
        }
    }
}

