/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.docmgr.Document;
import com.arsdigita.cms.docmgr.ui.authoring.DocumentPropertyForm;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.web.Web;

public class DocumentPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public DocumentPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        DocumentPropertyForm editSheet = new DocumentPropertyForm(itemModel);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(DocumentPropertiesStep.getDocumentPropertySheet(itemModel));
    }

    public static Component getDocumentPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel, false);
        sheet.add("Name:", "name");
        sheet.add("Title:", "title");
        sheet.add("Description:", "description");
        sheet.add("File:", "file", (DomainObjectPropertySheet.AttributeFormatter)new FileFormatter());
        return sheet;
    }

    public static class FileFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        private String m_default;

        public FileFormatter() {
            this("<i>no file</i>");
        }

        public FileFormatter(String def) {
            this.m_default = def;
        }

        public String getDefaultString() {
            return this.m_default;
        }

        public String format(DomainObject obj, String attribute, PageState state) {
            DataObject fileDO = (DataObject)((ContentItem)obj).get(attribute);
            if (fileDO == null) {
                return this.getDefaultString();
            }
            FileAsset file = new FileAsset(fileDO);
            Document doc = (Document)file.getParent();
            String alt = "";
            String altStr = "";
            String altVerb = "unknown";
            if (doc != null) {
                alt = doc.getDescription();
                altStr = " alt=\"" + alt + "\" ";
                altVerb = doc.getTitle();
            }
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("<a href=\"");
            sbuf.append(Web.getConfig().getDispatcherServletPath());
            sbuf.append(Utilities.getAssetURL((BinaryAsset)file));
            sbuf.append("\" ");
            sbuf.append(altStr);
            sbuf.append(">");
            sbuf.append(altVerb);
            sbuf.append("</a>");
            if (file.getMimeType() != null) {
                sbuf.append(" (");
                sbuf.append(file.getMimeType().getLabel());
                sbuf.append(")");
            }
            return sbuf.toString();
        }
    }
}

