/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.docmgr.ui.tree;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.docmgr.DocFolder;
import com.arsdigita.cms.docmgr.Repository;
import com.arsdigita.cms.docmgr.ui.DMConstants;
import com.arsdigita.cms.docmgr.ui.DMUtils;
import com.arsdigita.cms.docmgr.ui.tree.RepTreeNode;
import com.arsdigita.cms.docmgr.ui.tree.RootTreeNode;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RepositoryTreeModel
implements TreeModel,
DMConstants {
    private static BigDecimal REPOSITORIES_ROOT_ID = new BigDecimal(0);
    private static final Logger s_log = Logger.getLogger(RepositoryTreeModel.class);

    public TreeNode getRoot(PageState state) {
        Repository repository = (Repository)Web.getContext().getApplication();
        DocFolder root = repository.getRoot();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("root folder is " + root.getTitle()));
            s_log.debug((Object)("root folder id is " + root.getID().toString()));
        }
        return new RepTreeNode(root);
    }

    public boolean hasChildren(TreeNode n, PageState state) {
        BigDecimal folderID;
        DocFolder df;
        if (n instanceof RootTreeNode) {
            return true;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("node key is " + n.getKey()));
            s_log.debug((Object)("node value is " + n.getElement()));
        }
        return !(df = new DocFolder(folderID = DMUtils.getSelFolderOrRootID(state, n))).isEmpty();
    }

    public Iterator getChildren(TreeNode n, PageState state) {
        BigDecimal folderID = DMUtils.getSelFolderOrRootID(state, n);
        if (folderID.equals(REPOSITORIES_ROOT_ID)) {
            Repository currentRepository = (Repository)Web.getContext().getApplication();
            DocFolder root = currentRepository.getRoot();
            ArrayList<RepTreeNode> list = new ArrayList<RepTreeNode>();
            list.add(new RepTreeNode(root));
            return list.iterator();
        }
        DocFolder df = new DocFolder(folderID);
        Folder.ItemCollection collection = df.getItems();
        collection.addFolderFilter(true);
        collection.clearOrder();
        collection.addOrder("item.name");
        return new RepositoryIterator(collection);
    }

    private class RepositoryIterator
    implements Iterator {
        private Folder.ItemCollection m_collection;

        public RepositoryIterator(Folder.ItemCollection collection) {
            this.m_collection = collection;
        }

        @Override
        public boolean hasNext() {
            if (!this.m_collection.isEmpty()) {
                if (this.m_collection.next()) {
                    return true;
                }
                this.m_collection.close();
            }
            return false;
        }

        public Object next() {
            DocFolder df = (DocFolder)this.m_collection.getContentItem();
            return new RepTreeNode(df);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

