/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalworkspace.ui.homepage;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portalworkspace.Workspace;
import com.arsdigita.portalworkspace.WorkspacePage;
import com.arsdigita.portalworkspace.WorkspacePageCollection;
import com.arsdigita.subsite.Subsite;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import org.apache.log4j.Logger;

public class HomepageWorkspaceSelectionModel {
    private RequestLocal m_loaded = new RequestLocal();
    private RequestLocal m_global = new RequestLocal();
    private RequestLocal m_personal = new RequestLocal();
    private RequestLocal m_left = new RequestLocal();
    private RequestLocal m_middle = new RequestLocal();
    private RequestLocal m_right = new RequestLocal();
    private RequestLocal m_custom = new RequestLocal();
    private static Logger s_log = Logger.getLogger((String)HomepageWorkspaceSelectionModel.class.getName());

    public WorkspacePage getPortal(PageState state, int column) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadWorkspacePages(state);
        }
        if (column == 0) {
            return (WorkspacePage)this.m_left.get(state);
        }
        if (column == 1) {
            return (WorkspacePage)this.m_middle.get(state);
        }
        if (column == 2) {
            Party party = Kernel.getContext().getParty();
            WorkspacePage right = (WorkspacePage)this.m_right.get(state);
            PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)right, party);
            if (this.m_custom.get(state) == null || PermissionService.checkPermission((PermissionDescriptor)admin) || !Workspace.getConfig().getCreateUserWorkspaces()) {
                s_log.debug((Object)"Returning global portal");
                return (WorkspacePage)this.m_right.get(state);
            }
            s_log.debug((Object)"Returning personal portal");
            return (WorkspacePage)this.m_custom.get(state);
        }
        throw new UncheckedWrapperException("column out of range (0..2)");
    }

    public void onCustomize(PageState state, int column) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadWorkspacePages(state);
        }
        Party party = Kernel.getContext().getParty();
        Assert.exists((Object)party, Party.class);
        if (column == 2 && Workspace.getConfig().getCreateUserWorkspaces()) {
            WorkspacePage portal;
            Workspace global = this.getTopWorkspace();
            WorkspacePage right = (WorkspacePage)this.m_right.get(state);
            PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)right, party);
            if (PermissionService.checkPermission((PermissionDescriptor)admin)) {
                s_log.debug((Object)"Party has admin on global portal");
                return;
            }
            if (this.m_custom.get(state) != null) {
                s_log.debug((Object)"Party has custom portal already");
                return;
            }
            s_log.debug((Object)"Looking for custom column 2");
            Workspace custom = null;
            try {
                custom = global.retrieveSubworkspaceForParty(party);
                s_log.debug((Object)"Found exsting personal workspce");
            }
            catch (DataObjectNotFoundException ex) {
                s_log.debug((Object)"Created new personal workspace");
                custom = Workspace.createWorkspace((String)("personal-" + party.getID()), (String)("Personal Workspace for " + party.getDisplayName()), (Application)global, (User)((User)party));
            }
            s_log.debug((Object)"Looking for portal");
            this.m_personal.set(state, (Object)custom);
            WorkspacePageCollection portals = custom.getPages();
            portals.addOrder("sortKey");
            if (portals.next()) {
                s_log.debug((Object)"Found portal");
                portal = portals.getPage();
                portals.close();
            } else {
                s_log.debug((Object)"Create portal");
                portal = custom.addPage("Custom", "Custom page");
            }
            this.m_custom.set(state, (Object)portal);
        }
    }

    public void onReset(PageState state, int column) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadWorkspacePages(state);
        }
        Party party = Kernel.getContext().getParty();
        Assert.exists((Object)party, Party.class);
        WorkspacePage clear = null;
        if (column == 2 && Workspace.getConfig().getCreateUserWorkspaces()) {
            Workspace global = this.getTopWorkspace();
            Workspace custom = null;
            try {
                custom = global.retrieveSubworkspaceForParty(party);
                Assert.isTrue((custom.getParty() != null && custom.getParty().equals((Object)party) ? 1 : 0) != 0, (String)"party is not null and not admin");
                s_log.debug((Object)"Found exsting personal workspce");
                custom.delete();
                this.m_custom.set(state, null);
            }
            catch (DataObjectNotFoundException ex) {
                clear = (WorkspacePage)this.m_right.get(state);
            }
        } else if (column == 1) {
            clear = (WorkspacePage)this.m_middle.get(state);
        } else if (column == 0) {
            clear = (WorkspacePage)this.m_left.get(state);
        }
        if (clear != null) {
            clear.clearPortlets();
        }
    }

    public Workspace getGlobalWorkspace(PageState state) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadWorkspacePages(state);
        }
        return (Workspace)this.m_global.get(state);
    }

    public Workspace getPersonalWorkspace(PageState state) {
        if (!Boolean.TRUE.equals(this.m_loaded.get(state))) {
            this.loadWorkspacePages(state);
        }
        return (Workspace)this.m_personal.get(state);
    }

    private void loadWorkspacePages(PageState state) {
        Workspace global = this.getTopWorkspace();
        this.m_global.set(state, (Object)global);
        WorkspacePage left = null;
        WorkspacePage middle = null;
        WorkspacePage right = null;
        WorkspacePageCollection portals = global.getPages();
        portals.addOrder("sortKey");
        while (portals.next()) {
            WorkspacePage portal = portals.getPage();
            if (portal.getSortKey() == 0) {
                left = portal;
                continue;
            }
            if (portal.getSortKey() == 1) {
                middle = portal;
                continue;
            }
            if (portal.getSortKey() != 2) continue;
            right = portal;
        }
        if (left == null) {
            left = global.addPage("Left", "Left hand page");
        }
        if (middle == null) {
            middle = global.addPage("Middle", "Middle page");
        }
        if (right == null) {
            right = global.addPage("Right", "Right hand page");
        }
        this.m_left.set(state, (Object)left);
        this.m_middle.set(state, (Object)middle);
        this.m_right.set(state, (Object)right);
        Party party = Kernel.getContext().getParty();
        this.m_custom.set(state, null);
        if (party != null) {
            Workspace custom = null;
            try {
                custom = global.retrieveSubworkspaceForParty(party);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (custom != null) {
                portals = custom.getPages();
                portals.addOrder("sortKey");
                if (portals.next()) {
                    WorkspacePage portal = portals.getPage();
                    this.m_custom.set(state, (Object)portal);
                }
                portals.close();
            }
            s_log.debug((Object)("Is there a custom portal ?" + custom + " - " + this.m_custom.get(state)));
            this.m_personal.set(state, (Object)custom);
        }
        this.m_loaded.set(state, (Object)Boolean.TRUE);
    }

    protected Workspace getTopWorkspace() {
        if (Subsite.getContext().hasSite()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Return a subsite front page");
            }
            return (Workspace)Subsite.getContext().getSite().getFrontPage();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Return the main front page");
        }
        return (Workspace)Kernel.getContext().getResource();
    }
}

