/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.csv.PublicationsImporter;
import com.arsdigita.cms.scipublications.importer.report.AuthorImportReport;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.AuthorData;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class AbstractPublicationImporter<T extends Publication> {
    private static final String AUTHORS_SEP = ";";
    private static final String AUTHOR_NAME_SEP = ",";
    private static final String[] EDITOR_STRS = new String[]{"(Hrsg.)", "(Hg.)", "(Ed.)", "(ed.)"};
    private final CsvLine data;
    private final PublicationImportReport report;
    private final boolean pretend;
    private final ImporterUtil importerUtil;

    public AbstractPublicationImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        this.data = data;
        this.report = report;
        this.pretend = pretend;
        this.importerUtil = importerUtil;
    }

    protected CsvLine getData() {
        return this.data;
    }

    protected ImporterUtil getImporterUtil() {
        return this.importerUtil;
    }

    protected PublicationImportReport getReport() {
        return this.report;
    }

    protected boolean isPretend() {
        return this.pretend;
    }

    public final void doImport(boolean publishNewItems) {
        T publication = this.importPublication();
        if (!this.pretend) {
            publication.save();
            this.assignCategories(publication.getPublicationBundle());
            if (publishNewItems) {
                this.importerUtil.publishItem(publication);
            }
        }
        this.report.setSuccessful(true);
    }

    protected T importPublication() {
        T publication = this.createPublication();
        this.processTitleAndName(publication);
        this.processYear(publication);
        this.processReviewed(publication);
        if (!this.pretend) {
            publication.save();
            Integer folderId = this.getFolderId();
            Folder folder = new Folder(new BigDecimal(folderId));
            publication.setContentSection(folder.getContentSection());
            publication.setLanguage(Kernel.getConfig().getLanguagesIndependentCode());
            publication.save();
            PublicationBundle bundle = this.createBundle(publication);
            bundle.setParent((ACSObject)folder);
            bundle.setContentSection(folder.getContentSection());
            bundle.save();
            if (this.data.getAbstract().length() < 3975) {
                publication.setAbstract(this.data.getAbstract());
            } else {
                publication.setAbstract(this.data.getAbstract().substring(0, 3975));
            }
            if (this.data.getMisc().length() < 3975) {
                publication.setMisc(this.data.getMisc());
            } else {
                publication.setMisc(this.data.getMisc().substring(0, 3975));
            }
            publication.save();
        }
        if (this.data.getAuthors() != null && !this.data.getAuthors().isEmpty()) {
            this.processAuthors(publication);
        }
        return publication;
    }

    protected abstract T createPublication();

    protected abstract PublicationBundle createBundle(T var1);

    protected Integer getFolderId() {
        return Publication.getConfig().getDefaultPublicationsFolder();
    }

    private void processTitleAndName(T publication) {
        if (!this.pretend) {
            publication.setTitle(this.data.getTitle());
            String name = this.normalizeString(this.data.getTitle());
            if (name.length() > 200) {
                name = name.substring(0, 200);
            }
            publication.setName(name);
        }
        this.report.setTitle(this.data.getTitle());
    }

    private void processYear(T publication) {
        if (!this.pretend) {
            String year = this.data.getYear();
            try {
                publication.setYearOfPublication(Integer.valueOf(Integer.parseInt(year)));
            }
            catch (NumberFormatException ex) {
                publication.setYearOfPublication(Integer.valueOf(0));
            }
        }
        this.report.addField(new FieldImportReport("year", this.data.getYear()));
    }

    private void processReviewed(T publication) {
        String reviewedStr = this.data.getReviewed();
        boolean reviewed = "y".equalsIgnoreCase(reviewedStr) ? true : ("j".equalsIgnoreCase(reviewedStr) ? true : ("yes".equalsIgnoreCase(reviewedStr) ? true : ("ja".equalsIgnoreCase(reviewedStr) ? true : ("t".equalsIgnoreCase(reviewedStr) ? true : "true".equalsIgnoreCase(reviewedStr)))));
        if (!this.pretend) {
            publication.setReviewed(Boolean.valueOf(reviewed));
        }
        this.report.addField(new FieldImportReport("reviewed", Boolean.toString(reviewed)));
    }

    private void processAuthors(T publication) {
        List<AuthorData> authorsData = this.parseAuthors(this.data.getAuthors());
        for (AuthorData authorData : authorsData) {
            AuthorImportReport authorReport = this.importerUtil.processAuthor(publication, authorData, this.pretend);
            this.report.addAuthor(authorReport);
        }
    }

    protected final String normalizeString(String str) {
        if (str == null) {
            return "null";
        }
        return str.replace("\u00e4", "ae").replace("\u00f6", "oe").replace("\u00fc", "ue").replace("\u00c4", "Ae").replace("\u00dc", "Ue").replace("\u00d6", "Oe").replace("\u00df", "ss").replace(" ", "-").replaceAll("[^a-zA-Z0-9\\-]", "").toLowerCase().trim();
    }

    protected List<AuthorData> parseAuthors(String authorsStr) {
        String[] tokens;
        ArrayList<AuthorData> authors = new ArrayList<AuthorData>();
        for (String token : tokens = authorsStr.split(AUTHORS_SEP)) {
            this.parseAuthor(token, authors);
        }
        return authors;
    }

    private void parseAuthor(String authorToken, List<AuthorData> authors) {
        String[] nameTokens = authorToken.split(AUTHOR_NAME_SEP);
        if (nameTokens.length == 1) {
            AuthorData author = new AuthorData();
            author.setSurname(this.checkForEditor(author, nameTokens[0]));
            authors.add(author);
        } else if (nameTokens.length == 2) {
            AuthorData author = new AuthorData();
            author.setSurname(this.checkForEditor(author, nameTokens[0]));
            author.setGivenName(this.checkForEditor(author, nameTokens[1]));
            authors.add(author);
        } else {
            AuthorData author = new AuthorData();
            author.setSurname(this.checkForEditor(author, nameTokens[0]));
            author.setGivenName(this.checkForEditor(author, nameTokens[1]));
            authors.add(author);
        }
    }

    private String checkForEditor(AuthorData author, String token) {
        for (String editorStr : EDITOR_STRS) {
            if (!token.endsWith(editorStr)) continue;
            author.setEditor(true);
            return token.substring(0, token.length() - editorStr.length()).trim();
        }
        return token.trim();
    }

    private void assignCategories(PublicationBundle publicationBundle) {
        if (this.data.getScope() != null && "Pers\u00f6nlich".equals(this.data.getScope())) {
            return;
        }
        String[] departments = this.data.getDepartment().split(AUTHOR_NAME_SEP);
        Category defaultCat = PublicationsImporter.getConfig().getDefaultCategory();
        if (defaultCat != null) {
            defaultCat.addChild((ACSObject)publicationBundle);
        }
        Map<String, Category> depCats = PublicationsImporter.getConfig().getDepartmentCategories();
        for (String department : departments) {
            Category category = depCats.get(department);
            if (category == null) continue;
            category.addChild((ACSObject)publicationBundle);
        }
    }
}

