/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.contenttypes.PublicationWithPublisher;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

abstract class AbstractPublicationWithPublisherImporter<T extends PublicationWithPublisher>
extends AbstractPublicationImporter<T> {
    public AbstractPublicationWithPublisherImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    protected T importPublication() {
        PublicationWithPublisher publication = (PublicationWithPublisher)super.importPublication();
        CsvLine data = this.getData();
        if (data.getIsbn() != null && !data.getIsbn().isEmpty()) {
            String isbn = data.getIsbn().replace("-", "");
            if (!this.isPretend() && isbn.length() == 13) {
                publication.setISBN(data.getIsbn());
            }
            if (isbn.length() == 13) {
                this.getReport().addField(new FieldImportReport("isbn", isbn));
            } else {
                this.getReport().addMessage(String.format("Invalid ISBN at line %d.", data.getLineNumber()));
            }
        }
        this.processVolume(publication);
        this.processNumberOfVolumes(publication);
        this.processNumberOfPages(publication);
        if (data.getEdition() != null && !data.getEdition().isEmpty()) {
            if (!this.isPretend()) {
                publication.setEdition(data.getEdition());
            }
            this.getReport().addField(new FieldImportReport("edition", data.getEdition()));
        }
        if (data.getPublisher() != null && !data.getPublisher().isEmpty()) {
            this.getImporterUtil().processPublisher(publication, this.getData().getPlace(), this.getData().getPublisher(), this.isPretend());
        }
        return (T)publication;
    }

    private void processVolume(T publication) {
        if (this.getData().getVolume() != null && !this.getData().getVolume().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getVolume());
                if (!this.isPretend()) {
                    publication.setVolume(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Volume", this.getData().getVolume()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse volume data in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    private void processNumberOfVolumes(T publication) {
        if (this.getData().getNumberOfVolumes() != null && !this.getData().getNumberOfVolumes().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getNumberOfVolumes());
                if (!this.isPretend()) {
                    publication.setNumberOfVolumes(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Number of volumes", this.getData().getNumberOfVolumes()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse number of volumes data in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    private void processNumberOfPages(T publication) {
        if (this.getData().getNumberOfPages() != null && !this.getData().getNumberOfPages().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getNumberOfPages());
                if (!this.isPretend()) {
                    publication.setNumberOfPages(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Number of pages", this.getData().getNumberOfPages()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse numberOfPages data in line %d.", this.getData().getLineNumber()));
            }
        }
    }
}

