/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.contenttypes.UnPublished;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.OrganizationalUnitImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

abstract class AbstractUnPublishedImporter<T extends UnPublished>
extends AbstractPublicationImporter<T> {
    protected AbstractUnPublishedImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    protected T importPublication() {
        UnPublished publication = (UnPublished)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        if (data.getPlace() != null && !data.getPlace().isEmpty()) {
            if (!this.isPretend()) {
                publication.setPlace(data.getPlace());
            }
            report.addField(new FieldImportReport("place", data.getPlace()));
        }
        this.processNumberOfPages(publication);
        this.processOrganization(publication);
        return (T)publication;
    }

    private void processNumberOfPages(T publication) {
        if (this.getData().getNumberOfPages() != null && !this.getData().getNumberOfPages().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getNumberOfPages());
                if (!this.isPretend()) {
                    publication.setNumberOfPages(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Number of pages", this.getData().getNumberOfPages()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse numberOfPages data in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    private void processOrganization(T publication) {
        if (this.getData().getPublisher() != null && !this.getData().getPublisher().isEmpty()) {
            OrganizationalUnitImportReport report = this.getImporterUtil().processOrganization(publication, this.getData().getPublisher(), this.isPretend());
            this.getReport().addOrgaUnit(report);
        }
    }
}

