/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import java.util.Arrays;

class CsvLine {
    private final String[] cols;
    private final int lineNumber;

    public CsvLine(String[] cols, int lineNumber) {
        if (cols.length != 30) {
            throw new IllegalArgumentException(String.format("Unexpected number of columns. Expected 30 columns, but provided array has %d entries.", cols.length));
        }
        this.cols = Arrays.copyOf(cols, cols.length);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getTitle() {
        return this.cols[0].trim();
    }

    public String getYear() {
        return this.cols[1].trim();
    }

    public String getAuthors() {
        return this.cols[2].trim();
    }

    public String getType() {
        return this.cols[3].trim();
    }

    public String getAbstract() {
        return this.cols[4].trim();
    }

    public String getMisc() {
        return this.cols[5].trim();
    }

    public String getReviewed() {
        return this.cols[6].trim();
    }

    public String getDepartment() {
        return this.cols[7].trim();
    }

    public String getPlace() {
        return this.cols[8].trim();
    }

    public String getPublisher() {
        return this.cols[9].trim();
    }

    public String getVolume() {
        return this.cols[10].trim();
    }

    public String getNumberOfVolumes() {
        return this.cols[11].trim();
    }

    public String getNumberOfPages() {
        return this.cols[12].trim();
    }

    public String getEdition() {
        return this.cols[13].trim();
    }

    public String getPageFrom() {
        return this.cols[14].trim();
    }

    public String getPageTo() {
        return this.cols[15].trim();
    }

    public String getChapter() {
        return this.cols[16].trim();
    }

    public String getIssue() {
        return this.cols[17].trim();
    }

    public String getPublicationDate() {
        return this.cols[18].trim();
    }

    public String getJournal() {
        return this.cols[19].trim();
    }

    public String getCollectedVolume() {
        return this.cols[20].trim();
    }

    public String getCollectedVolumeAuthors() {
        return this.cols[21].trim();
    }

    public String getIsbn() {
        return this.cols[22].trim();
    }

    public String getIssn() {
        return this.cols[23].trim();
    }

    public String getLastAccess() {
        return this.cols[24].trim();
    }

    public String getUrl() {
        return this.cols[25].trim();
    }

    public String getUrn() {
        return this.cols[26].trim();
    }

    public String getDoi() {
        return this.cols[27].trim();
    }

    public String getConference() {
        return this.cols[28].trim();
    }

    public String getScope() {
        return this.cols[29].trim();
    }
}

