/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.GreyLiterature;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.contenttypes.UnPublishedBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractUnPublishedImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

class GreyLiteratureImporter
extends AbstractUnPublishedImporter<GreyLiterature> {
    protected GreyLiteratureImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    protected GreyLiterature importPublication() {
        GreyLiterature publication = (GreyLiterature)super.importPublication();
        this.processPagesFrom(publication);
        this.processPagesTo(publication);
        return publication;
    }

    private void processPagesFrom(GreyLiterature publication) {
        if (this.getData().getPageFrom() != null && !this.getData().getPageFrom().isEmpty()) {
            try {
                int pagesFrom = Integer.parseInt(this.getData().getPageFrom());
                if (!this.isPretend()) {
                    publication.setPagesFrom(Integer.valueOf(pagesFrom));
                }
                this.getReport().addField(new FieldImportReport("Pages from", this.getData().getPageFrom()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse pageFrom data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPagesTo(GreyLiterature publication) {
        try {
            int pagesTo = Integer.parseInt(this.getData().getPageTo());
            if (!this.isPretend()) {
                publication.setPagesTo(Integer.valueOf(pagesTo));
            }
            this.getReport().addField(new FieldImportReport("Pages to", this.getData().getPageTo()));
        }
        catch (NumberFormatException ex) {
            this.getReport().addMessage(String.format("Failed to parse pageTo data in line '%d'.", this.getData().getLineNumber()));
        }
    }

    @Override
    protected GreyLiterature createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new GreyLiterature();
    }

    @Override
    protected PublicationBundle createBundle(GreyLiterature greyLiterature) {
        if (this.isPretend()) {
            return null;
        }
        return new UnPublishedBundle((ContentItem)greyLiterature);
    }
}

