/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.InProceedings;
import com.arsdigita.cms.contenttypes.InProceedingsBundle;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

class InProceedingsImporter
extends AbstractPublicationImporter<InProceedings> {
    public InProceedingsImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    protected InProceedings importPublication() {
        InProceedings inProceedings = (InProceedings)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        ImporterUtil importerUtil = this.getImporterUtil();
        this.processPagesFrom(inProceedings);
        this.processPagesTo(inProceedings);
        report.setProceedings(importerUtil.processProceedings(inProceedings, data.getCollectedVolume(), data.getYear(), data.getConference(), this.parseAuthors(data.getCollectedVolumeAuthors()), data.getPublisher(), data.getPlace(), this.isPretend()));
        return inProceedings;
    }

    private void processPagesFrom(InProceedings publication) {
        if (this.getData().getPageFrom() != null && !this.getData().getPageFrom().isEmpty()) {
            try {
                int pagesFrom = Integer.parseInt(this.getData().getPageFrom());
                if (!this.isPretend()) {
                    publication.setPagesFrom(Integer.valueOf(pagesFrom));
                }
                this.getReport().addField(new FieldImportReport("Pages from", this.getData().getPageFrom()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse pageFrom data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPagesTo(InProceedings publication) {
        try {
            int pagesTo = Integer.parseInt(this.getData().getPageTo());
            if (!this.isPretend()) {
                publication.setPagesTo(Integer.valueOf(pagesTo));
            }
            this.getReport().addField(new FieldImportReport("Pages to", this.getData().getPageTo()));
        }
        catch (NumberFormatException ex) {
            this.getReport().addMessage(String.format("Failed to parse pageTo data in line '%d'.", this.getData().getLineNumber()));
        }
    }

    @Override
    protected InProceedings createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new InProceedings();
    }

    @Override
    protected PublicationBundle createBundle(InProceedings inProceedings) {
        if (this.isPretend()) {
            return null;
        }
        return new InProceedingsBundle((ContentItem)inProceedings);
    }

    @Override
    protected Integer getFolderId() {
        return Publication.getConfig().getDefaultInProceedingsFolder();
    }
}

