/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.atoz.ui.admin.TermWidget;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.categorization.Category;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import java.math.BigDecimal;

public class CategoryProviderAliasForm
extends Form {
    private ACSObjectSelectionModel m_provider;
    private TermWidget m_termWidget;
    private TextField m_title;
    private SingleSelect m_letter;
    private SaveCancelSection m_buttons;

    public CategoryProviderAliasForm(ACSObjectSelectionModel provider) {
        super("categoryAliasForm", (Container)new SimpleContainer());
        this.setRedirecting(true);
        this.m_provider = provider;
        this.m_title = new TextField("title");
        this.m_title.addValidationListener((ParameterListener)new StringInRangeValidationListener(1, 200));
        this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_title.setSize(80);
        this.m_letter = new SingleSelect("letter");
        this.m_letter.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_letter.addOption(new Option(null, "--Select one--"));
        for (int i = 0; i < 26; ++i) {
            String letter = new String(new char[]{(char)(97 + i)});
            this.m_letter.addOption(new Option(letter, letter.toUpperCase()));
        }
        this.add((Component)this.m_title);
        this.add((Component)this.m_letter);
        this.m_termWidget = new TermWidget(provider);
        this.m_termWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_termWidget);
        this.m_buttons = new SaveCancelSection((Container)new SimpleContainer());
        this.add((Component)this.m_buttons);
        this.addProcessListener(new ProviderProcessListener());
        this.addSubmissionListener(new ProviderSubmissionListener());
    }

    private class ProviderProcessListener
    implements FormProcessListener {
        private ProviderProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            CategoryProvider provider = (CategoryProvider)CategoryProviderAliasForm.this.m_provider.getSelectedObject(state);
            Category cat = new Category(((BigDecimal[])CategoryProviderAliasForm.this.m_termWidget.getValue(state))[0]);
            String letter = (String)CategoryProviderAliasForm.this.m_letter.getValue(state);
            String title = (String)CategoryProviderAliasForm.this.m_title.getValue(state);
            provider.addAlias(cat, letter, title);
            CategoryProviderAliasForm.this.fireCompletionEvent(state);
        }
    }

    private class ProviderSubmissionListener
    implements FormSubmissionListener {
        private ProviderSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (CategoryProviderAliasForm.this.m_buttons.getCancelButton().isSelected(state)) {
                CategoryProviderAliasForm.this.fireCompletionEvent(state);
                throw new FormProcessException("cancel hit");
            }
        }
    }
}

