/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.AtoZ;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ProviderList
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger(ProviderList.class);
    private static final String XMLNS = "http://xmlns.redhat.com/atoz/1.0";
    private static final String EDIT = "edit";
    private static final String DELETE = "delete";
    private ACSObjectSelectionModel m_provider;

    public ProviderList(ACSObjectSelectionModel provider) {
        super("atoz:providerList", XMLNS);
        this.m_provider = provider;
    }

    public void respond(PageState state) {
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (EDIT.equals(key)) {
            AtoZProvider provider = (AtoZProvider)DomainObjectFactory.newInstance((OID)OID.valueOf((String)value));
            this.m_provider.setSelectedObject(state, (DomainObject)provider);
        } else if (DELETE.equals(key)) {
            AtoZProvider provider = (AtoZProvider)DomainObjectFactory.newInstance((OID)OID.valueOf((String)value));
            provider.delete();
            this.m_provider.clearSelection(state);
        } else {
            s_log.warn((Object)("Unknown control event " + key + ":" + value));
        }
    }

    public void generateXML(PageState state, Element parent) {
        Element content = this.generateParent(parent);
        AtoZ atoz = (AtoZ)Kernel.getContext().getResource();
        DomainCollection providers = atoz.getProviders();
        while (providers.next()) {
            AtoZProvider provider = (AtoZProvider)providers.getDomainObject();
            Element providerEl = content.newChildElement("atoz:provider", XMLNS);
            try {
                state.setControlEvent((Component)this, DELETE, provider.getOID().toString());
                providerEl.addAttribute("deleteURL", state.stateAsURL());
                state.setControlEvent((Component)this, EDIT, provider.getOID().toString());
                providerEl.addAttribute("editURL", state.stateAsURL());
                state.clearControlEvent();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("damn", (Throwable)ex);
            }
            if (provider.equals(this.m_provider.getSelectedObject(state))) {
                providerEl.addAttribute("isSelected", "yes");
            }
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(providerEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)provider, ProviderList.class.getName());
        }
    }
}

