/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.ui.admin;

import com.arsdigita.atoz.CategoryProvider;
import com.arsdigita.bebop.PageState;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.Term;
import com.arsdigita.london.terms.Terms;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public class TermWidget
extends com.arsdigita.london.terms.ui.TermWidget {
    private static final Logger s_log = Logger.getLogger(TermWidget.class);
    private ACSObjectSelectionModel m_provider;

    public TermWidget(ACSObjectSelectionModel provider) {
        super(null, null);
        this.m_provider = provider;
    }

    protected void generateWidget(PageState state, Element parent) {
        Domain domain = this.getDomain(state);
        Element widget = parent.newChildElement("cms:categoryWidget", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(widget);
        widget.addAttribute("mode", "javascript");
        widget.addAttribute("name", this.getName());
        HashSet<BigDecimal> ids = new HashSet<BigDecimal>();
        BigDecimal[] values = (BigDecimal[])this.getValue(state);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                ids.add(values[i]);
            }
        }
        DomainCollection terms = domain.getRootTerms();
        terms.addPath("model.parents.link.sortKey");
        terms.addPath("model.parents.id");
        terms.addPath("domain.key");
        terms.addPath("model.objectType");
        terms.addPath("model.displayName");
        terms.addPath("model.defaultDomainClass");
        terms.addPath("model.name");
        terms.addPath("model.description");
        terms.addPath("model.url");
        terms.addPath("model.isEnabled");
        terms.addPath("model.isAbstract");
        terms.addPath("model.defaultAncestors");
        LinkedList<TermSortKeyPair> roots = new LinkedList<TermSortKeyPair>();
        while (terms.next()) {
            Term term = (Term)terms.getDomainObject();
            roots.add(new TermSortKeyPair(term, (BigDecimal)terms.get("model.parents.link.sortKey")));
        }
        Element el = TermWidget.generateCategory((Element)widget, (Category)domain.getModel(), ids, null);
        if (Terms.getConfig().ajaxExpandAllBranches()) {
            el.addAttribute("expand", "all");
        }
        for (TermSortKeyPair pair : roots) {
            Term term = pair.getTerm();
            BigDecimal sortKey = pair.getSortKey();
            TermWidget.generateRootTerm(el, term, ids, sortKey);
        }
    }

    private static void generateRootTerm(Element parent, Term term, Set selected, BigDecimal sortKey) {
        Element el = TermWidget.generateTerm((Element)parent, (Term)term, (Set)selected, (BigDecimal)sortKey);
        el.addAttribute("root", "1");
    }

    protected Domain getDomain(PageState state) {
        CategoryProvider provider = (CategoryProvider)this.m_provider.getSelectedObject(state);
        Category root = Category.getRootForObject((ACSObject)provider);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting domain for " + root.getID()));
        }
        DataCollection domains = SessionManager.getSession().retrieve("com.arsdigita.london.terms.Domain");
        domains.addEqualsFilter("model.id", (Object)root.getID());
        if (domains.next()) {
            Domain domain = (Domain)DomainObjectFactory.newInstance((DataObject)domains.getDataObject());
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Got domain " + domain));
            }
            domains.close();
            return domain;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"No domain found");
        }
        return null;
    }

    private static class TermSortKeyPair {
        private Term m_term;
        private BigDecimal m_sortKey;

        public TermSortKeyPair(Term term, BigDecimal sortKey) {
            this.m_term = term;
            this.m_sortKey = sortKey;
        }

        public Term getTerm() {
            return this.m_term;
        }

        public BigDecimal getSortKey() {
            return this.m_sortKey;
        }
    }
}

