/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.GenericArticle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class LegalNotice
extends GenericArticle {
    public static final String GOVERNMENT_UID = "governmentUID";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.LegalNotice";
    private static final Logger s_log = Logger.getLogger(LegalNotice.class);
    public static final int SUMMARY_LENGTH = 200;

    public LegalNotice() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public LegalNotice(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public LegalNotice(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public LegalNotice(DataObject obj) {
        super(obj);
    }

    public LegalNotice(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public String getGovernmentUID() {
        return (String)this.get(GOVERNMENT_UID);
    }

    public void setGovernmentUID(String governmentUID) {
        this.set(GOVERNMENT_UID, governmentUID);
    }

    public String getSearchSummary() {
        TextAsset ta = this.getTextAsset();
        if (ta != null) {
            return StringUtils.truncateString((String)ta.getText(), (int)200, (boolean)true);
        }
        return "";
    }
}

