/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.auth.http.HTTPAuth;
import com.arsdigita.auth.http.Inet4AddressRange;
import com.arsdigita.auth.http.UserLogin;
import com.arsdigita.db.Sequences;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.security.HTTPRequestCallback;
import com.arsdigita.kernel.security.HTTPResponseCallback;
import com.arsdigita.kernel.security.MappingLoginModule;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.Cipher;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class HTTPLoginModule
extends MappingLoginModule {
    private static Logger s_log = Logger.getLogger(HTTPLoginModule.class);
    private static PublicKey s_publicKey = null;
    private static BASE64Decoder s_base64Decoder;
    private static final String TTL = "60";
    private Subject m_subject;
    private CallbackHandler m_handler;
    private Map m_shared;
    private Map m_options;
    private BigDecimal m_userID = null;
    private Boolean m_secure = null;
    private Cipher m_decrypt = this.getDecryptionCipher();

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        this.m_subject = subject;
        this.m_handler = handler;
        this.m_shared = shared;
        this.m_options = options;
        super.initialize(subject, handler, shared, options);
    }

    public boolean login() throws LoginException {
        String auth;
        String userAgent;
        boolean isIE;
        HttpServletResponse res;
        HttpServletRequest req;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"HTTP Login Start");
        }
        if (this.m_decrypt == null) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"No public key available, falling back to default");
            }
            return false;
        }
        try {
            HTTPRequestCallback reqCB = new HTTPRequestCallback();
            HTTPResponseCallback resCB = new HTTPResponseCallback();
            this.m_handler.handle(new Callback[]{reqCB, resCB});
            req = reqCB.getRequest();
            res = resCB.getResponse();
        }
        catch (Exception e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        Inet4AddressRange range = HTTPAuth.getConfig().getClientIPRange();
        if (range != null) {
            InetAddress address;
            String ipaddress = req.getHeader("X-Forwarded-For");
            if (ipaddress == null) {
                ipaddress = req.getRemoteAddr();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Remote Address = " + ipaddress));
                }
            } else {
                int index;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Proxy forwarded chain is " + ipaddress));
                }
                if ((index = ipaddress.indexOf(44)) != -1) {
                    ipaddress = ipaddress.substring(0, index);
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Proxy forwarded client is " + ipaddress));
                }
            }
            try {
                address = InetAddress.getByName(ipaddress);
            }
            catch (UnknownHostException ex) {
                s_log.warn((Object)("Unknown host " + ipaddress), (Throwable)ex);
                return false;
            }
            catch (SecurityException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Address = " + address));
                s_log.debug((Object)("Range = " + range));
            }
            if (!range.inRange(address)) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Address not in range");
                }
                return false;
            }
        }
        boolean bl = isIE = (userAgent = req.getHeader("user-agent")) != null && userAgent.toLowerCase().indexOf("msie") != -1;
        if (!isIE) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"User not using IE, falling back to default login");
            }
            return false;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Attempting HTTP authentication");
        }
        if ((auth = req.getParameter("__camden_auth")) == null) {
            String nonce;
            try {
                nonce = Sequences.getNextValue().toString();
                DataOperation op = SessionManager.getSession().retrieveDataOperation("com.arsdigita.auth.ntlm.AddNonce");
                op.setParameter("nonce", (Object)nonce);
                op.setParameter("expires", (Object)new Date(new Date().getTime() + (long)HTTPAuth.getConfig().getNonceTTL() * 1000L));
                op.setParameter("status", (Object)Boolean.FALSE);
                op.execute();
                op.close();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Added nonce: " + nonce));
                }
            }
            catch (Exception e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            String returnURL = "http://" + KernelHelper.getHostName() + req.getRequestURI();
            if (req.getQueryString() != null) {
                returnURL = returnURL + "?" + req.getQueryString();
            }
            returnURL = URLEncoder.encode(returnURL);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Return URL: " + returnURL));
            }
            String redirectURL = "http://" + HTTPAuth.getConfig().getServerName() + ":" + HTTPAuth.getConfig().getServerPort() + "/auth/" + "?nonce=" + nonce + "&returnURL=" + returnURL;
            this.clearCookie(req, res);
            throw new RedirectSignal(redirectURL, true);
        }
        try {
            byte[] decAuthBytes = s_base64Decoder.decodeBuffer(auth);
            auth = new String(this.m_decrypt.doFinal(decAuthBytes));
        }
        catch (Exception e) {
            s_log.warn((Object)("Error checking nonce value: " + e));
            e.printStackTrace();
            throw new LoginException("Invalid signature from authentication server");
        }
        if (!auth.startsWith("camden")) {
            s_log.warn((Object)("Invalid signature from authentication server - no MAGIC (auth was: " + auth + ")"));
            throw new LoginException("Invalid signature from authentication server");
        }
        auth = auth.substring("camden".length());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Decrypted Auth: " + auth));
        }
        int sep = auth.indexOf("|");
        String nonce = auth.substring(0, sep);
        String user = auth.substring(sep + 1);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Nonce: " + nonce));
            s_log.debug((Object)("User: " + user));
        }
        DataQuery check = SessionManager.getSession().retrieveQuery("com.arsdigita.auth.ntlm.CheckNonce");
        check.setParameter("now", (Object)new Date());
        check.setParameter("nonce", (Object)nonce);
        check.setParameter("status", (Object)Boolean.FALSE);
        boolean nonceInvalid = check.isEmpty();
        check.close();
        if (nonceInvalid) {
            s_log.warn((Object)("Received invalid nonce: " + nonce));
            throw new LoginException("Invalid challenge string from authentication server");
        }
        DataOperation expire = SessionManager.getSession().retrieveDataOperation("com.arsdigita.auth.ntlm.ExpireNonce");
        expire.setParameter("nonce", (Object)nonce);
        expire.setParameter("status", (Object)Boolean.TRUE);
        expire.execute();
        expire.close();
        this.m_shared.put("javax.security.auth.login.name", user);
        Enumeration vars = req.getParameterNames();
        StringBuffer requestURL = new StringBuffer(req.getRequestURI());
        if (vars.hasMoreElements()) {
            requestURL.append('?');
            boolean first = true;
            while (vars.hasMoreElements()) {
                String key = (String)vars.nextElement();
                String[] vals = req.getParameterValues(key);
                for (int i = 0; i < vals.length; ++i) {
                    if ("__camden_auth".equals(key)) continue;
                    if (first) {
                        first = false;
                    } else {
                        requestURL.append('&');
                    }
                    requestURL.append(key);
                    requestURL.append('=');
                    requestURL.append(vals[i]);
                }
            }
        }
        this.m_shared.put("com.arsdigita.auth.http.RedirectURL", requestURL.toString());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"HTTP Login End");
        }
        return super.login();
    }

    private void clearCookie(HttpServletRequest req, HttpServletResponse res) throws LoginException {
        Cookie cookie = new Cookie(this.isSecure(req) ? "ad_user_login_secure" : "ad_user_login", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setSecure(this.isSecure(req));
        res.addCookie(cookie);
    }

    protected final boolean isSecure(HttpServletRequest req) throws LoginException {
        if (this.m_secure == null) {
            this.m_secure = new Boolean(Util.getSecurityHelper().isSecure(req));
        }
        return this.m_secure;
    }

    protected BigDecimal getUserID(String ident) throws LoginException {
        UserLogin login = UserLogin.findByLogin(ident);
        if (login == null) {
            s_log.warn((Object)("No entry for user " + ident));
            throw new LoginException("No entry for user " + ident);
        }
        return login.getUser().getID();
    }

    private Cipher getDecryptionCipher() {
        Cipher decrypt;
        if (s_publicKey == null) {
            return null;
        }
        try {
            decrypt = Cipher.getInstance(HTTPAuth.getConfig().getKeyCypher());
            decrypt.init(2, s_publicKey);
        }
        catch (GeneralSecurityException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        return decrypt;
    }

    public boolean commit() throws LoginException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Commit");
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Abort");
        }
        return super.commit();
    }

    static {
        s_log.debug((Object)"Static initalizer starting...");
        if (HTTPAuth.getConfig().isActive()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Loading public key");
            }
            s_publicKey = HTTPAuth.getConfig().getPublicKey();
        } else if (s_log.isInfoEnabled()) {
            s_log.info((Object)"HTTP auth is not active");
        }
        s_log.debug((Object)"Static initalizer finished.");
        s_base64Decoder = new BASE64Decoder();
    }
}

