/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet4AddressRange {
    private InetAddress m_address;
    private InetAddress m_netmask;

    public static Inet4AddressRange getByName(String s) {
        InetAddress address;
        InetAddress netmask;
        try {
            int i = s.indexOf(47);
            if (i == -1) {
                netmask = Inet4AddressRange.makeNetmask(32);
                address = InetAddress.getByName(s);
            } else {
                String addrString = s.substring(0, i);
                String netmaskString = s.substring(i + 1, s.length());
                address = InetAddress.getByName(addrString);
                netmask = !Inet4AddressRange.isNumber(netmaskString) ? InetAddress.getByName(netmaskString) : Inet4AddressRange.makeNetmask(Integer.parseInt(netmaskString));
            }
        }
        catch (UnknownHostException ex) {
            return null;
        }
        catch (SecurityException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        return new Inet4AddressRange(address, netmask);
    }

    private static boolean isNumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) >= '0' && s.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    public Inet4AddressRange(InetAddress address, InetAddress netmask) {
        this.m_address = address;
        this.m_netmask = netmask;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public InetAddress getNetmask() {
        return this.m_netmask;
    }

    public String toString() {
        return Inet4AddressRange.inetAddressToString(this.m_address) + "/" + Inet4AddressRange.inetAddressToString(this.m_netmask);
    }

    public boolean equals(Inet4AddressRange other) {
        return this.m_address.equals(other.m_address) && this.m_netmask.equals(other.m_netmask);
    }

    public boolean inRange(InetAddress address) {
        long maddressLong = Inet4AddressRange.inetAddressToLong(this.m_address);
        long mnetmaskLong = Inet4AddressRange.inetAddressToLong(this.m_netmask);
        long addressLong = Inet4AddressRange.inetAddressToLong(address);
        return (addressLong & mnetmaskLong) == maddressLong;
    }

    public static long inetAddressToLong(InetAddress address) {
        byte[] bytes = address.getAddress();
        long a = bytes[0];
        long b = bytes[1];
        long c = bytes[2];
        long d = bytes[3];
        return (a &= 0xFFL) << 24 | (b &= 0xFFL) << 16 | (c &= 0xFFL) << 8 | (d &= 0xFFL);
    }

    public static InetAddress longToInetAddress(long address) {
        try {
            return InetAddress.getByName(String.valueOf(address));
        }
        catch (UnknownHostException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    public static String inetAddressToString(InetAddress address) {
        byte[] bytes = address.getAddress();
        long a = bytes[0];
        long b = bytes[1];
        long c = bytes[2];
        long d = bytes[3];
        return (a &= 0xFFL) + "." + (b &= 0xFFL) + "." + (c &= 0xFFL) + "." + (d &= 0xFFL);
    }

    private static InetAddress makeNetmask(int bits) throws UnknownHostException, SecurityException {
        long n = -4294967296L >> bits & 0xFFFFFFFFL;
        return Inet4AddressRange.longToInetAddress(n);
    }

    public static void main(String[] args) throws Exception {
        InetAddress addr = InetAddress.getByName("192.168.0.99");
        InetAddress addr2 = Inet4AddressRange.longToInetAddress(Inet4AddressRange.inetAddressToLong(addr));
        String addrStr = Inet4AddressRange.inetAddressToString(addr);
        String addr2Str = Inet4AddressRange.inetAddressToString(addr2);
        System.out.println("addr = " + addrStr + "; addr2 = " + addr2Str);
        Assert.isTrue((boolean)addrStr.equals(addr2Str));
        addr = Inet4AddressRange.makeNetmask(0);
        System.out.println("makeNetmask(0) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("0.0.0.0"));
        addr = Inet4AddressRange.makeNetmask(8);
        System.out.println("makeNetmask(8) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("255.0.0.0"));
        addr = Inet4AddressRange.makeNetmask(16);
        System.out.println("makeNetmask(16) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("255.255.0.0"));
        addr = Inet4AddressRange.makeNetmask(24);
        System.out.println("makeNetmask(24) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("255.255.255.0"));
        addr = Inet4AddressRange.makeNetmask(28);
        System.out.println("makeNetmask(28) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("255.255.255.240"));
        addr = Inet4AddressRange.makeNetmask(32);
        System.out.println("makeNetmask(32) = " + addr);
        Assert.isTrue((boolean)Inet4AddressRange.inetAddressToString(addr).equals("255.255.255.255"));
        Inet4AddressRange range = Inet4AddressRange.getByName("192.168.0.0/16");
        System.out.println("range = " + range.toString());
        Inet4AddressRange range2 = Inet4AddressRange.getByName("192.168.0.0/255.255.0.0");
        System.out.println("range = " + range.toString());
        Assert.isTrue((boolean)range.equals(range2));
        range = Inet4AddressRange.getByName("192.168.0.99");
        System.out.println("range = " + range.toString());
        range = Inet4AddressRange.getByName("192.168.0.0/16");
        addr = InetAddress.getByName("192.168.0.99");
        Assert.isTrue((boolean)range.inRange(addr));
        range = Inet4AddressRange.getByName("192.168.0.0/24");
        addr = InetAddress.getByName("192.168.2.99");
        Assert.isTrue((!range.inRange(addr) ? 1 : 0) != 0);
        range = Inet4AddressRange.getByName("192.168.0.99");
        addr = InetAddress.getByName("192.168.0.99");
        Assert.isTrue((boolean)range.inRange(addr));
        range = Inet4AddressRange.getByName("192.168.0.99");
        addr = InetAddress.getByName("192.168.3.99");
        Assert.isTrue((!range.inRange(addr) ? 1 : 0) != 0);
        System.out.println("All test completed OK.");
    }
}

