/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http.ui;

import com.arsdigita.auth.http.ui.UserForm;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import org.apache.log4j.Category;

public class EditUserPane
extends SimpleContainer {
    private static final Category s_log = Category.getInstance(EditUserPane.class);
    private static final String DISPLAY_USER = "displayUser";
    private Component m_pane = this;
    protected BigDecimalParameter m_userID = new BigDecimalParameter("userID");
    protected Form m_searchForm;
    protected TextField m_search;
    protected List m_users;
    protected UserForm m_userForm;
    protected RequestLocal m_user = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            BigDecimal id = (BigDecimal)ps.getValue((ParameterModel)EditUserPane.this.m_userID);
            s_log.debug((Object)("userID = " + id));
            try {
                return User.retrieve((BigDecimal)id);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.warn((Object)("No user with id " + id));
                return null;
            }
        }
    };

    public EditUserPane() {
        this.m_search = new TextField("search");
        this.m_searchForm = new Form("searchForm", (Container)new BoxPanel(1));
        this.m_searchForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) {
                EditUserPane.this.setSelecting(e.getPageState());
            }
        });
        this.m_searchForm.add((Component)new Label("Find users with names containing"));
        this.m_searchForm.add((Component)this.m_search);
        this.m_searchForm.add((Component)new Submit("Find Users"));
        this.m_users = new List();
        this.m_users.setModelBuilder(new ListModelBuilder(){
            private boolean m_locked = false;

            public ListModel makeModel(List l, PageState ps) {
                return new UserListModel(EditUserPane.this.m_search.getValue(ps).toString());
            }

            public boolean isLocked() {
                return this.m_locked;
            }

            public void lock() {
                this.m_locked = true;
            }
        });
        this.m_users.setCellRenderer((ListCellRenderer)new UserListCellRenderer());
        this.m_userForm = new UserForm(this.m_user);
        this.m_userForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) {
                EditUserPane.this.setSearching(e.getPageState());
            }
        });
        this.add((Component)this.m_searchForm);
        this.add((Component)this.m_users);
        this.add((Component)this.m_userForm);
    }

    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        String value = ps.getControlEventValue();
        if (DISPLAY_USER.equals(event)) {
            ps.setValue((ParameterModel)this.m_userID, (Object)new BigDecimal(value));
            this.setEditing(ps);
        }
        super.respond(ps);
    }

    public void register(Page p) {
        p.setVisibleDefault((Component)this.m_users, false);
        p.setVisibleDefault((Component)this.m_userForm, false);
        p.addGlobalStateParam((ParameterModel)this.m_userID);
        super.register(p);
    }

    private void setEditing(PageState ps) {
        this.m_users.setVisible(ps, false);
        this.m_userForm.setVisible(ps, true);
    }

    private void setSelecting(PageState ps) {
        this.m_users.setVisible(ps, true);
        this.m_userForm.setVisible(ps, false);
    }

    private void setSearching(PageState ps) {
        this.m_users.setVisible(ps, false);
        this.m_userForm.setVisible(ps, false);
    }

    private class UserListCellRenderer
    implements ListCellRenderer {
        private UserListCellRenderer() {
        }

        public Component getComponent(List list, PageState ps, Object value, String key, int index, boolean isSelected) {
            ps.setControlEvent(EditUserPane.this.m_pane, EditUserPane.DISPLAY_USER, key);
            return new ControlLink(value.toString());
        }
    }

    private class UserListModel
    implements ListModel {
        private DataQuery m_users = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");

        public UserListModel(String search) {
            this.m_users.setParameter("excludeGroupId", (Object)"0");
            Filter f = this.m_users.addFilter("searchName like :search");
            search = "%" + search + "%";
            f.set("search", (Object)search);
        }

        public boolean next() {
            boolean next = this.m_users.next();
            return next;
        }

        public Object getElement() {
            String firstName = (String)this.m_users.get("firstName");
            String lastName = (String)this.m_users.get("lastName");
            return firstName + " " + lastName;
        }

        public String getKey() {
            return this.m_users.get("userID").toString();
        }
    }
}

