/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.atoz.siteproxy;

import com.arsdigita.atoz.AtoZAtomicEntry;
import com.arsdigita.atoz.AtoZCompoundEntry;
import com.arsdigita.atoz.AtoZEntry;
import com.arsdigita.atoz.AtoZGeneratorAbstractImpl;
import com.arsdigita.atoz.AtoZProvider;
import com.arsdigita.atoz.siteproxy.SiteProxyProvider;
import com.arsdigita.cms.dispatcher.SiteProxyPanel;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.url.URLData;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SiteProxyGenerator
extends AtoZGeneratorAbstractImpl {
    public SiteProxyGenerator(AtoZProvider provider) {
        super(provider);
    }

    public AtoZEntry[] getEntries(String letter) {
        SiteProxyProvider siteProxyProvider = (SiteProxyProvider)this.getProvider();
        DataQuery entries = siteProxyProvider.getAtomicEntries(letter);
        ArrayList<AtoZCategoriesCompoundEntry> list = new ArrayList<AtoZCategoriesCompoundEntry>();
        BigDecimal previousCatId = new BigDecimal(-1);
        AtoZCategoriesCompoundEntry compoundEntry = null;
        while (entries.next()) {
            SiteProxyAtomicEntry atomicEntry;
            if (previousCatId.compareTo((BigDecimal)entries.get("categoryId")) != 0) {
                if (compoundEntry != null && compoundEntry.entries.size() > 0) {
                    list.add(compoundEntry);
                }
                compoundEntry = new AtoZCategoriesCompoundEntry((String)entries.get("categoryTitle"), (String)entries.get("categoryDescription"));
                previousCatId = (BigDecimal)entries.get("categoryId");
            }
            if ((atomicEntry = new SiteProxyAtomicEntry(new OID("com.arsdigita.cms.contenttypes.SiteProxy", entries.get("id")), (String)entries.get("title"), (String)entries.get("url"))).getContent() == null) continue;
            compoundEntry.entries.add(atomicEntry);
        }
        if (compoundEntry != null && compoundEntry.entries.size() > 0) {
            list.add(compoundEntry);
        }
        return list.toArray(new AtoZEntry[list.size()]);
    }

    private class SiteProxyAtomicEntry
    implements AtoZAtomicEntry {
        private static final String SITE_PROXY_PANEL_NAME = "cms:siteProxyPanel";
        private OID m_oid;
        private String m_title;
        private String m_url;

        public SiteProxyAtomicEntry(OID oid, String title, String url) {
            this.m_oid = oid;
            this.m_title = title;
            this.m_url = url;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getDescription() {
            return null;
        }

        public String getLink() {
            ParameterMap map = new ParameterMap();
            map.setParameter("oid", this.m_oid.toString());
            URL here = Web.getContext().getRequestURL();
            return new URL(here.getScheme(), here.getServerName(), here.getServerPort(), "", "", "/redirect/", map).toString();
        }

        public Element getContent() {
            if (this.m_url == null) {
                return null;
            }
            Element child = new Element(SITE_PROXY_PANEL_NAME, "http://www.arsdigita.com/cms/1.0");
            child.addAttribute("title", this.m_title);
            child.addAttribute("oid", this.m_oid.toString());
            URLData data = SiteProxyPanel.internalGetRemoteXML((Element)child, (String)this.m_url);
            if (data == null) {
                return null;
            }
            if (data.getException() != null) {
                return null;
            }
            return child;
        }
    }

    private class AtoZCategoriesCompoundEntry
    implements AtoZCompoundEntry {
        private List entries = new ArrayList();
        private String m_title;
        private String m_description;

        public AtoZCategoriesCompoundEntry(String title, String description) {
            this.m_title = title;
            this.m_description = description;
        }

        public AtoZEntry[] getEntries() {
            return this.entries.toArray(new AtoZEntry[this.entries.size()]);
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getDescription() {
            return this.m_description;
        }
    }
}

