/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.GenericArticle;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class Agenda
extends GenericArticle {
    public static final String SUMMARY = "summary";
    public static final String AGENDA_DATE = "agendaDate";
    public static final String LOCATION = "location";
    public static final String ATTENDEES = "attendees";
    public static final String SUBJECT_ITEMS = "subjectItems";
    public static final String CONTACT_INFO = "contactInfo";
    public static final String CREATION_DATE = "creationDate";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.Agenda";
    private static final Logger s_log = Logger.getLogger(Logger.class);
    public static final int SUMMARY_LENGTH = 200;

    public Agenda() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Agenda(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Agenda(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public Agenda(DataObject obj) {
        super(obj);
    }

    public Agenda(String type) {
        super(type);
    }

    public void beforeSave() {
        super.beforeSave();
        Assert.exists((Object)this.getContentType(), ContentType.class);
    }

    public Date getAgendaDate() {
        return (Date)this.get(AGENDA_DATE);
    }

    public String getDisplayAgendaDate() {
        Date d = this.getAgendaDate();
        return d != null ? DateFormat.getDateInstance(1).format(d) : null;
    }

    public void setAgendaDate(Date agendaDate) {
        this.set(AGENDA_DATE, agendaDate);
    }

    public String getLocation() {
        return (String)this.get(LOCATION);
    }

    public void setLocation(String location) {
        this.set(LOCATION, location);
    }

    public String getAttendees() {
        return (String)this.get(ATTENDEES);
    }

    public void setAttendees(String attendees) {
        this.set(ATTENDEES, attendees);
    }

    public String getSubjectItems() {
        return (String)this.get(SUBJECT_ITEMS);
    }

    public void setSubjectItems(String subjectItems) {
        this.set(SUBJECT_ITEMS, subjectItems);
    }

    public String getContactInfo() {
        return (String)this.get(CONTACT_INFO);
    }

    public void setContactInfo(String contactInfo) {
        this.set(CONTACT_INFO, contactInfo);
    }

    public String getSummary() {
        return (String)this.get(SUMMARY);
    }

    public void setSummary(String summary) {
        this.set(SUMMARY, summary);
    }

    public Date getCreationDate() {
        return (Date)this.get(CREATION_DATE);
    }

    public void setCreationDate(Date creationDate) {
        this.set(CREATION_DATE, creationDate);
    }

    public String getSearchSummary() {
        TextAsset ta = this.getTextAsset();
        if (ta != null) {
            return StringUtils.truncateString((String)ta.getText(), (int)200, (boolean)true);
        }
        return "";
    }
}

