/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Agenda;
import com.arsdigita.cms.contenttypes.ui.AgendaPropertyForm;
import com.arsdigita.cms.contenttypes.util.AgendaGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class AgendaPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public AgendaPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        AgendaPropertyForm editSheet = new AgendaPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(AgendaPropertiesStep.getAgendaPropertySheet(itemModel));
    }

    public static Component getAgendaPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.name").localize(), "name");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.title").localize(), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add((String)AgendaGlobalizationUtil.globalize("cms.ui.authoring.page_launch_date").localize(), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1, GlobalizationHelper.getNegotiatedLocale()).format(page.getLaunchDate());
                    }
                    return (String)AgendaGlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.summary").localize(), "summary");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.agenda_date").localize(), "agendaDate");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.location").localize(), "location");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.attendees").localize(), "attendees");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.subject_items").localize(), "subjectItems");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.contact_info").localize(), "contactInfo");
        sheet.add((String)AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.creation_date").localize(), "agendaDate", new DomainObjectPropertySheet.AttributeFormatter(){

            public String format(DomainObject item, String attribute, PageState state) {
                Agenda agenda = (Agenda)item;
                if (agenda.getCreationDate() != null) {
                    return DateFormat.getDateInstance(1, GlobalizationHelper.getNegotiatedLocale()).format(agenda.getCreationDate());
                }
                return (String)AgendaGlobalizationUtil.globalize("cms.ui.unknown").localize();
            }
        });
        return sheet;
    }
}

