/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.faq.Faq;
import com.arsdigita.faq.QAPair;
import com.arsdigita.faq.ui.FaqPage;
import com.arsdigita.faq.util.GlobalizationUtil;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.Filter;
import com.arsdigita.toolbox.ui.TextTypeWidget;
import com.arsdigita.util.TypedText;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FaqQuestionEntryForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener {
    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/FaqQuestionEntryForm.java#5 $$Author: dennis $$DateTime: 2004/08/17 23:26:27 $";
    private static Logger log = Logger.getLogger(Faq.class);
    private RequestLocal m_faqQuestion;

    FaqQuestionEntryForm() {
        super("faqQuestionEntry");
        this.setMethod("POST");
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.faq.ui.question")));
        StringParameter question = new StringParameter("question");
        question.addParameterListener((ParameterListener)new NotEmptyValidationListener());
        TextField question_tf = new TextField((ParameterModel)question);
        question_tf.setMaxLength(1000);
        this.add((Component)question_tf);
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.faq.ui.answer")));
        StringParameter answer = new StringParameter("answer");
        answer.addParameterListener((ParameterListener)new NotEmptyValidationListener());
        answer.addParameterListener((ParameterListener)new StringLengthValidationListener(4000));
        this.add((Component)new TextArea((ParameterModel)answer, 4, 40, 2));
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.faq.ui.text_type")));
        this.add((Component)new TextTypeWidget((ParameterModel)new StringParameter("answerTextType")));
        this.add((Component)new Submit("Save"), 66);
        this.addProcessListener(this);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.m_faqQuestion = new RequestLocal(){

            protected Object initialValue(PageState state) {
                BigDecimal id = ((FaqPage)state.getPage()).getQuestionID(state);
                if (id == null) {
                    return null;
                }
                try {
                    return new QAPair(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    return null;
                }
            }
        };
    }

    private QAPair getQAPair(PageState state) {
        QAPair pair = (QAPair)((Object)this.m_faqQuestion.get(state));
        return pair;
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        QAPair pair;
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        BigDecimal id = ((FaqPage)state.getPage()).getQuestionID(state);
        if (id != null && (pair = this.getQAPair(state)) != null) {
            data.put((Object)"question", (Object)pair.getQuestion());
            data.put((Object)"answer", (Object)pair.getAnswer().getText());
            data.put((Object)"answerTextType", (Object)pair.getAnswer().getType());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        QAPair pair = this.getQAPair(state);
        String name = (String)data.get((Object)"question");
        Faq faq = ((FaqPage)state.getPage()).getFaq(state);
        DataAssociationCursor pairs = faq.getQAPairs().cursor();
        Filter f = pairs.addFilter("upper(question) = :name");
        f.set("name", (Object)name.toUpperCase());
        BigDecimal id = ((FaqPage)state.getPage()).getQuestionID(state);
        if (id != null) {
            pairs.addNotEqualsFilter("id", (Object)id);
        }
        if (pairs.next()) {
            data.addError("question", "This question already exists.");
        }
        pairs.close();
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        QAPair pair;
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        BigDecimal id = ((FaqPage)state.getPage()).getQuestionID(state);
        Faq faq = ((FaqPage)state.getPage()).getFaq(state);
        if (id != null) {
            pair = this.getQAPair(state);
            if (pair == null) {
                throw new FormValidationException("The object you are editing cannot be found in the database.");
            }
            pair.setQuestion((String)data.get((Object)"question"));
            pair.setAnswer(new TypedText((String)data.get((Object)"answer"), (String)data.get((Object)"answerTextType")));
        } else {
            pair = faq.createQuestion((String)data.get((Object)"question"), new TypedText((String)data.get((Object)"answer"), (String)data.get((Object)"answerTextType")));
        }
        pair.save();
        this.fireCompletionEvent(state);
    }
}

