/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.web.Web;
import org.apache.log4j.Logger;

public class ApplicationAuthenticationListener
extends UserAuthenticationListener
implements RequestListener {
    private static final Logger s_log = Logger.getLogger(ApplicationAuthenticationListener.class);
    private String m_privilegeName;

    public ApplicationAuthenticationListener(String privilegeName) {
        this.m_privilegeName = privilegeName;
    }

    public void setRequiredPrivilege(String privilegeName) {
        this.m_privilegeName = privilegeName;
    }

    public String getRequiredPrivilege() {
        return this.m_privilegeName;
    }

    public void pageRequested(RequestEvent event) {
        PageState state = event.getPageState();
        PrivilegeDescriptor privDescriptor = PrivilegeDescriptor.get((String)this.m_privilegeName);
        PermissionDescriptor permDescriptor = new PermissionDescriptor(privDescriptor, (ACSObject)Web.getContext().getApplication(), Kernel.getContext().getParty());
        if (!PermissionService.checkPermission((PermissionDescriptor)permDescriptor)) {
            this.denyRequest(state);
        }
    }

    public void denyRequest(PageState state) {
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
            return;
        }
        throw new AccessDeniedException();
    }
}

