/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.docrepo.DocBlobject;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Resource;
import com.arsdigita.docrepo.ResourceException;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.docrepo.TypeChangeException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class File
extends ResourceImpl {
    protected static Logger s_log = Logger.getLogger(File.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.docrepo.File";
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static Perl5Util s_re = new Perl5Util();
    private static final String PATTERN = "/^([^\\.].*)(\\.\\w+)$/";
    private static final byte[] EMPTY_BYTES = new byte[0];

    public File(DataObject dataObject) {
        super(dataObject);
    }

    public File(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public File(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public File(String name, String description, Folder parent) {
        this(BASE_DATA_OBJECT_TYPE, name, description, parent);
    }

    public File(String baseDataObjectType, String name, String description, Folder parent) {
        super(baseDataObjectType, name, description, parent);
    }

    public File(Folder parent) {
        super(BASE_DATA_OBJECT_TYPE, parent);
    }

    public File(String objectType) {
        super(objectType);
    }

    public static File retrieveFile(DataObject dataObject) {
        Assert.exists((Object)dataObject, DataObject.class);
        return new File(dataObject);
    }

    @Override
    protected void beforeSave() {
        this.set("isFolder", Boolean.FALSE);
        super.beforeSave();
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getContentType() {
        return (String)this.get("mimeType");
    }

    public String getPrettyContentType() {
        MimeType mimeType;
        String type = this.getContentType();
        if (type != null && (mimeType = MimeType.loadMimeType((String)type)) != null) {
            type = mimeType.getLabel();
        }
        return type;
    }

    private void setContentType(String type) {
        if (this.isNew()) {
            this.set("mimeType", type);
        } else if (!type.equals(this.getContentType())) {
            throw new TypeChangeException(this.getContentType(), type);
        }
    }

    public void setContent(java.io.File file, String name, String description, String mimeType) throws ResourceException {
        FileDataSource source = new FileDataSource(file);
        this.setContent((DataSource)source, name, description, mimeType);
        this.setName(name);
        this.setDescription(description);
        this.setContentType(mimeType);
    }

    public void setContent(DataSource source, String name, String description, String mimeType) throws ResourceException {
        DataHandler dh = new DataHandler(source);
        this.setDataHandler(dh);
        this.setName(name);
        this.setDescription(description);
        this.setContentType(mimeType);
    }

    public final void setText(String text) {
        byte[] content = text.getBytes();
        DocBlobject dblob = new DocBlobject();
        dblob.setContent(content);
        this.set("content", (Object)dblob);
        this.set("size", BigDecimal.valueOf(content.length));
        this.setContentType("text/plain");
    }

    public InputStream getInputStream() {
        DataObject data = (DataObject)this.get("content");
        if (data == null) {
            throw new DataObjectNotFoundException("Doc Blob not found");
        }
        DocBlobject dobj = (DocBlobject)DomainObjectFactory.newInstance((DataObject)data);
        return new ByteArrayInputStream(dobj.getContent());
    }

    public byte[] getRawContent() {
        DataObject data = (DataObject)this.get("content");
        if (data == null) {
            return EMPTY_BYTES;
        }
        DocBlobject dobj = (DocBlobject)DomainObjectFactory.newInstance((DataObject)data);
        return dobj.getContent();
    }

    private void setDataHandler(DataHandler dh) throws ResourceException {
        try {
            int ch;
            InputStream is = dh.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            byte[] content = os.toByteArray();
            DocBlobject dblob = new DocBlobject();
            dblob.setContent(content);
            this.set("content", (Object)dblob);
            this.set("size", BigDecimal.valueOf(content.length));
        }
        catch (IOException e) {
            throw new ResourceException("error reading content: " + e.getMessage());
        }
    }

    public BigDecimal getSize() {
        BigDecimal size = (BigDecimal)this.get("size");
        if (size != null) {
            return size;
        }
        return BigDecimal.valueOf(0L);
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public Resource copyTo(String name, Resource parent) {
        File dest = new File((Folder)parent);
        File.copy(this, dest);
        dest.setName(name);
        dest.setContentType(this.getContentType());
        byte[] content = this.getRawContent();
        DocBlobject dblob = new DocBlobject();
        dblob.setContent(content);
        dest.set("content", (Object)dblob);
        dest.set("size", BigDecimal.valueOf(content.length));
        dest.save();
        return dest;
    }

    @Override
    protected Vector getPropertyNames() {
        Vector names = super.getPropertyNames();
        Iterator props = this.getObjectType().getDeclaredProperties();
        while (props.hasNext()) {
            names.addElement(((Property)props.next()).getName());
        }
        return names;
    }

    public String getDisplayName() {
        String name = this.getName();
        if (s_re.match(PATTERN, name)) {
            return s_re.group(1);
        }
        return name;
    }

    public boolean isValidNewName(String name) {
        boolean isValid;
        boolean bl = isValid = File.isValidName(name) == 0;
        if (isValid && !this.isNew()) {
            String contentType = Util.guessContentType(this.appendExtension(name), null);
            isValid = contentType.equals(this.getContentType());
        }
        return isValid;
    }

    public String appendExtension(String name) {
        String ext = File.getExtension(name);
        if (ext.equals("")) {
            name = name + File.getExtension(this.getName());
        }
        return name;
    }

    public static String getExtension(String name) {
        if (s_re.match(PATTERN, name)) {
            return s_re.group(2);
        }
        return "";
    }

    public void saveNewRevision(java.io.File src, String originalName, String versionDesc) {
        this.setContent(src, this.getName(), this.getDescription(), this.getContentType());
        this.applyTag(versionDesc);
        this.save();
    }
}

