/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class DRUtils
implements DRConstants {
    private static final Logger s_log = Logger.getLogger(DRUtils.class);

    DRUtils() {
    }

    public static Folder getRootFolder(PageState state) {
        Repository currentRepository = null;
        Application app = Web.getContext().getApplication();
        String sAppType = app.getApplicationType().getApplicationObjectType();
        String sUserProfileBaseObjectType = "com.arsdigita.userprofile.UserProfile";
        String sUserProfileRepoPath = "/cw-admin/user-profile/repository/";
        currentRepository = sAppType.compareTo(sUserProfileBaseObjectType) == 0 ? (Repository)Application.retrieveApplicationForPath((String)sUserProfileRepoPath) : (Repository)Web.getContext().getApplication();
        Folder root = currentRepository.getRoot();
        DRUtils.setRoot(state, root);
        return root;
    }

    public static BigDecimal getSelFolderOrRootID(PageState state, TreeNode n) {
        String idS = (String)n.getKey();
        if (idS != null) {
            return new BigDecimal(idS);
        }
        Folder root = DRUtils.getRootFolder(state);
        return root.getID();
    }

    public static void setRoot(PageState state, Folder root) {
        state.setValue((ParameterModel)ROOTFOLDER_ID_PARAM, (Object)root.getID());
    }

    public static User getUser(PageState state) {
        User user = Web.getContext().getUser();
        if (user == null) {
            throw new RuntimeException("User not logged in");
        }
        return user;
    }

    public static BigDecimal getSelectedFolderID(PageState state, Tree t) {
        String id = (String)t.getSelectedKey(state);
        if (id != null) {
            return new BigDecimal(id);
        }
        throw new RuntimeException("No tree node selected");
    }

    public static File getFile(BigDecimal id) {
        try {
            return new File(id);
        }
        catch (DataObjectNotFoundException nfe) {
            throw new ObjectNotFoundException("The requested file no longer exists.");
        }
    }

    public static String getFolderName(PageState state, Tree tree) {
        BigDecimal id = DRUtils.getSelectedFolderID(state, tree);
        Folder folder = null;
        try {
            folder = new Folder(id);
        }
        catch (DataObjectNotFoundException nfe) {
            throw new UncheckedWrapperException("Folder not found", (Throwable)nfe);
        }
        return folder.getName();
    }

    public static String extractFileName(String rawName, PageState state) {
        HttpServletRequest request = state.getRequest();
        String userAgent = request.getHeader("User-Agent").toUpperCase();
        int separator = userAgent.indexOf("WINDOWS") != -1 ? 92 : (userAgent.indexOf("MAC") != -1 ? 58 : 47);
        int idx = rawName.lastIndexOf(separator);
        if (idx != -1) {
            return rawName.substring(idx + 1);
        }
        return rawName;
    }

    public static class DateFormat {
        public static String format(Date date) {
            return DateFormat.format(date, "MM/dd/yy hh:mm a");
        }

        public static String format(Date date, String fmt) {
            SimpleDateFormat formatter = new SimpleDateFormat(fmt, Kernel.getContext().getLocale());
            return formatter.format(date);
        }
    }

    public static class FileSize {
        public static String formatFileSize(long n, PageState state) {
            double d;
            double d2;
            Locale locale = Kernel.getContext().getLocale();
            NumberFormat nf = NumberFormat.getNumberInstance(locale);
            nf.setMaximumFractionDigits(0);
            double size = n;
            if (size < 1000.0) {
                return nf.format(size) + " B";
            }
            size = FileSize.byteToKilo(n);
            if (d2 < 1000.0) {
                return nf.format(size) + " KB";
            }
            nf.setMaximumFractionDigits(2);
            size = FileSize.byteToMega(n);
            if (d < 1000.0) {
                return nf.format(size) + " MB";
            }
            return nf.format(size) + " GB";
        }

        public static String formatFileSize(BigDecimal size, PageState state) {
            return FileSize.formatFileSize(size.longValue(), state);
        }

        private static double byteToKilo(long size) {
            return (double)size / 1024.0;
        }

        private static double byteToMega(long size) {
            return (double)size / 1048576.0;
        }
    }
}

