/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.docrepo.ResourceImpl;
import com.arsdigita.docrepo.ui.BrowsePane;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DeleteSubmit;
import com.arsdigita.docrepo.ui.FolderTable;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import java.math.BigDecimal;
import java.util.ArrayList;

class FolderContentsTableForm
extends Form
implements FormProcessListener,
DRConstants {
    private Tree m_tree;
    private FolderTable m_folder;
    private SingleSelect m_actionSelect;
    private StringParameter m_action = new StringParameter("folder-action");
    private Submit m_deleteSubmit;
    private Submit m_copySubmit;
    private Submit m_moveSubmit;
    private SimpleContainer m_actionBar;
    private Label m_emptyFolderLabel;
    private BrowsePane m_parent;
    ResourceImpl m_resource;

    public FolderContentsTableForm(BrowsePane parent, Tree tree) {
        super("FolderContentAction", (Container)new ColumnPanel(1));
        this.m_tree = tree;
        this.m_parent = parent;
        this.m_folder = new FolderTable(this.m_tree, this);
        this.add((Component)this.m_folder);
        this.m_actionBar = new SimpleContainer();
        this.m_copySubmit = new Submit(ACTION_COPY_SUBMIT);
        this.m_actionBar.add((Component)this.m_copySubmit);
        this.m_moveSubmit = new Submit(ACTION_MOVE_SUBMIT);
        this.m_actionBar.add((Component)this.m_moveSubmit);
        this.m_deleteSubmit = new DeleteSubmit(ACTION_DELETE_SUBMIT);
        this.m_actionBar.add((Component)this.m_deleteSubmit);
        this.add((Component)this.m_actionBar);
        this.m_emptyFolderLabel = FOLDER_EMPTY_LABEL;
        this.add((Component)this.m_emptyFolderLabel);
        this.addProcessListener(this);
    }

    public void register(Page p) {
        p.setVisibleDefault((Component)this.m_actionBar, true);
        p.setVisibleDefault((Component)this.m_emptyFolderLabel, false);
        super.register(p);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        int i;
        PageState state = e.getPageState();
        ArrayList<String> msgList = new ArrayList<String>();
        boolean isError = false;
        String[] selectedItems = (String[])this.m_folder.getCheckboxGroup().getValue(state);
        if (selectedItems == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < selectedItems.length; ++i) {
            list.add(selectedItems[i]);
        }
        if (this.m_deleteSubmit.isSelected(state)) {
            for (i = 0; i < selectedItems.length; ++i) {
                OID oid = new OID("com.arsdigita.docrepo.ResourceImpl", (Object)new BigDecimal(selectedItems[i]));
                this.m_resource = null;
                try {
                    this.m_resource = (ResourceImpl)DomainObjectFactory.newInstance((OID)oid);
                    KernelExcursion ex = new KernelExcursion(){

                        protected void excurse() {
                            this.setEffectiveParty(Kernel.getSystemParty());
                            FolderContentsTableForm.this.m_resource.delete();
                        }
                    };
                    ex.run();
                    continue;
                }
                catch (PersistenceException exc) {
                    isError = true;
                    if (this.m_resource == null) continue;
                    msgList.add(this.m_resource.getName());
                    continue;
                }
                catch (DataObjectNotFoundException exc) {
                    isError = true;
                    if (this.m_resource == null) continue;
                    msgList.add(this.m_resource.getName());
                }
            }
        } else if (this.m_copySubmit.isSelected(state)) {
            this.m_parent.displayDestinationFolderPanel(state, list.toArray(), false);
        } else if (this.m_moveSubmit.isSelected(state)) {
            this.m_parent.displayDestinationFolderPanel(state, list.toArray(), true);
        }
        this.m_folder.getCheckboxGroup().setValue(state, null);
        if (isError) {
            this.m_parent.displayErrorMsgPanel(state, "delete", msgList);
        }
    }

    public void hideActionLinks(PageState state) {
        this.m_actionBar.setVisible(state, false);
        this.m_emptyFolderLabel.setVisible(state, true);
    }

    public void hideEmptyLabel(PageState state) {
        this.m_emptyFolderLabel.setVisible(state, false);
        this.m_actionBar.setVisible(state, true);
    }
}

