/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class CWPage
extends Page {
    private static final Logger s_log = Logger.getLogger(CWPage.class);
    private final Container m_global;
    private final Container m_header;
    private final Container m_body;
    private final Container m_footer;
    private IntegerParameter m_selected = new IntegerParameter("m");
    public static final String PORTAL_GLOBAL_ELEMENT = "portalserver:global";
    public static final String PORTAL_HEADER_ELEMENT = "portalserver:header";
    public static final String PORTAL_BODY_ELEMENT = "portalserver:body";
    public static final String PORTAL_FOOTER_ELEMENT = "portalserver:footer";
    public static final String PORTAL_XML_NS = "http://www.redhat.com/portalserver/1.0";

    protected CWPage() {
        super(new Label(), (Container)new SimpleContainer());
        this.setClassAttr("portalserver");
        this.m_panel = new Panel();
        this.addGlobalStateParam((ParameterModel)this.m_selected);
        this.m_global = new SimpleContainer(PORTAL_GLOBAL_ELEMENT, PORTAL_XML_NS);
        this.m_header = new SimpleContainer(PORTAL_HEADER_ELEMENT, PORTAL_XML_NS);
        this.m_body = new SimpleContainer(PORTAL_BODY_ELEMENT, PORTAL_XML_NS);
        this.m_footer = new SimpleContainer(PORTAL_FOOTER_ELEMENT, PORTAL_XML_NS);
        super.add((Component)this.m_global);
        super.add((Component)this.m_header);
        super.add((Component)this.m_body);
        super.add((Component)this.m_footer);
    }

    public void goModal(PageState ps, Component c) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        c.setVisible(ps, true);
        this.setSelected(ps, c);
    }

    private Component getSelected(PageState ps) {
        Integer stateIndex = (Integer)ps.getValue((ParameterModel)this.m_selected);
        Component c = null;
        if (stateIndex != null) {
            c = this.getComponent(stateIndex);
        }
        return c;
    }

    private void setSelected(PageState ps, Component c) {
        if (c == null) {
            ps.setValue((ParameterModel)this.m_selected, null);
        } else {
            ps.setValue((ParameterModel)this.m_selected, (Object)new Integer(this.stateIndex(c)));
        }
    }

    public void goUnmodal(PageState ps) {
        Component old = this.getSelected(ps);
        if (old != null) {
            old.setVisible(ps, false);
        }
        this.setSelected(ps, null);
    }

    public void add(Component pc) {
        Assert.isUnlocked((Lockable)this);
        this.m_body.add(pc);
    }

    public Container getGlobal() {
        return this.m_global;
    }

    public Container getHeader() {
        return this.m_header;
    }

    public Container getBody() {
        return this.m_body;
    }

    public Container getFooter() {
        return this.m_footer;
    }

    private class Panel
    extends SimpleContainer {
        private Panel() {
        }

        public void generateXML(PageState ps, Element p) {
            Component selected = CWPage.this.getSelected(ps);
            if (selected == null) {
                super.generateXML(ps, p);
            } else {
                SimpleContainer fakeBody = new SimpleContainer(CWPage.PORTAL_BODY_ELEMENT, CWPage.PORTAL_XML_NS);
                fakeBody.add(selected);
                Element parent = this.generateParent(p);
                CWPage.this.m_header.generateXML(ps, parent);
                fakeBody.generateXML(ps, parent);
                CWPage.this.m_footer.generateXML(ps, parent);
            }
        }
    }
}

