/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.portal.AgentPortlet;
import com.arsdigita.portalserver.ApplicationDirectoryPortlet;
import com.arsdigita.portalserver.CWURLFinder;
import com.arsdigita.portalserver.PortalNavigatorPortlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSummaryPortlet;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.SubPortalTab;
import com.arsdigita.portalserver.admin.PSAdmin;
import com.arsdigita.portalserver.personal.MyPortalsPortlet;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.personal.PersonalPortalConfig;
import com.arsdigita.portalserver.personal.PersonalPortalCreator;
import com.arsdigita.portalserver.ui.admin.PortalCreator;
import com.arsdigita.portalserver.ui.admin.PortalSiteMap;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.web.Application;

public class Initializer
extends CompoundInitializer {
    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-portalserver.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent evt) {
        super.init(evt);
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.Workspace", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSite(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.Role", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Role(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.WorkspaceTab", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalTab(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.SubWorkspaceTab", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new SubPortalTab(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.admin.CWAdmin", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PSAdmin(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.ui.WorkspaceCreator", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalCreator(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.ui.PortalSiteMap", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSiteMap(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.portal.AgentPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new AgentPortlet(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.ApplicationDirectoryPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new ApplicationDirectoryPortlet(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.personal.MyWorkspacesPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new MyPortalsPortlet(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.WorkspaceNavigatorPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalNavigatorPortlet(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.WorkspaceSummaryPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSummaryPortlet(dataObject);
            }
        });
        new PersonalPortalConfig();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.personal.PersonalWorkspaceCreator", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PersonalPortalCreator(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.personal.PersonalWorkspace", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PersonalPortal(dataObject);
            }
        });
        URLFinder forumFinder = new URLFinder(){

            public String find(OID oid) throws NoValidURLException {
                Application app = Application.retrieveApplication((OID)oid);
                return app.getPrimaryURL();
            }

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }
        };
        URLService.registerFinder((String)"com.arsdigita.web.Application", (URLFinder)forumFinder);
        CWURLFinder finder = new CWURLFinder("admin");
        URLService.registerFinder((String)"com.arsdigita.workspace.Workspace", (URLFinder)finder);
    }
}

