/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.permissions;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Completable;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.BooleanParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.util.Color;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.CWPage;
import com.arsdigita.portalserver.Icons;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.permissions.AddGrantForm;
import com.arsdigita.portalserver.permissions.ErrorMessageDisplay;
import com.arsdigita.portalserver.permissions.Grant;
import com.arsdigita.portalserver.permissions.GrantsTable;
import com.arsdigita.portalserver.permissions.PrivilegeSingleSelect;
import com.arsdigita.portalserver.permissions.TypeSingleSelect;
import com.arsdigita.portalserver.permissions.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Category;

public class ObjectPermissionEdit
extends CompoundComponent {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/permissions/ObjectPermissionEdit.java#3 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)ObjectPermissionEdit.class.getName());
    private static final RequestLocal s_dynamicLabel = new RequestLocal(){

        public Object initialValue(PageState ps) {
            return new Label();
        }
    };
    private static final long MAX_RESULTS = 20L;

    public void register(Page p) {
        Assert.isTrue((boolean)(p instanceof CWPage), (String)"ObjectPermissionEdit may only be used on instances of CWPage.");
        super.register(p);
    }

    private void initialize(RequestLocal objectRL, RequestLocal directTypesRL, RequestLocal indirectTypesRL) {
        SimpleContainer c = (SimpleContainer)this.getContainer();
        NewGrantDisplay newGrantDisplay = new NewGrantDisplay(objectRL, directTypesRL){

            @Override
            public void register(Page p) {
                super.register(p);
                p.setVisibleDefault((Component)this, false);
            }
        };
        ActionListener onAddClick = new ActionListener((Completable)newGrantDisplay){
            final /* synthetic */ Completable val$newGrantDisplay;
            {
                this.val$newGrantDisplay = completable;
            }

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                CWPage page = (CWPage)ps.getPage();
                page.goModal(ps, (Component)this.val$newGrantDisplay);
            }
        };
        MainDisplay mainDisplay = new MainDisplay(objectRL, directTypesRL, indirectTypesRL, onAddClick);
        newGrantDisplay.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                CWPage page = (CWPage)ps.getPage();
                page.goUnmodal(ps);
            }
        });
        this.add((Component)mainDisplay);
        this.add((Component)newGrantDisplay);
    }

    public ObjectPermissionEdit(RequestLocal objectRL) {
        super((Container)new SimpleContainer());
        this.initialize(objectRL, new RequestLocal(), new RequestLocal());
    }

    private class NewGrantDisplay
    extends CompoundComponent {
        private final RequestLocal m_objectRL;
        private final RequestLocal m_typesRL;
        private final StringParameter m_queryParam = new StringParameter("queryParam");
        private final BooleanParameter m_limitParam = new BooleanParameter("limitParam");
        private final RequestLocal m_partiesRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                PortalSite psite = PortalSite.getCurrentPortalSite(ps.getRequest());
                String queryString = (String)ps.getValue((ParameterModel)NewGrantDisplay.this.m_queryParam);
                Boolean limit = (Boolean)ps.getValue((ParameterModel)NewGrantDisplay.this.m_limitParam);
                PartyCollection parties = limit != null && limit != false ? psite.getParticipants() : Party.retrieveAllParties();
                parties.filter(queryString);
                return parties;
            }
        };

        private void clearQuery(PageState ps) {
            ps.setValue((ParameterModel)this.m_queryParam, null);
            ps.setValue((ParameterModel)this.m_limitParam, null);
        }

        private void setQuery(PageState ps, String query, Boolean limit) {
            ps.setValue((ParameterModel)this.m_queryParam, (Object)query);
            ps.setValue((ParameterModel)this.m_limitParam, (Object)limit);
        }

        private boolean haveQuery(PageState ps) {
            return ps.getValue((ParameterModel)this.m_queryParam) != null;
        }

        private PartyCollection getQueryResults(PageState ps) {
            if (!this.haveQuery(ps)) {
                throw new IllegalStateException("No query specified.");
            }
            return (PartyCollection)this.m_partiesRL.get(ps);
        }

        NewGrantDisplay(RequestLocal objectRL, RequestLocal typesRL) {
            this.m_objectRL = objectRL;
            this.m_typesRL = typesRL;
            BoxPanel screen1 = new BoxPanel(2){

                public boolean isVisible(PageState ps) {
                    if (!NewGrantDisplay.this.haveQuery(ps)) {
                        return true;
                    }
                    PartyCollection pc = NewGrantDisplay.this.getQueryResults(ps);
                    long n = pc.size();
                    return n == 0L || n > 20L;
                }
            };
            this.add((Component)screen1);
            BoldLabel roleFormTitle = new BoldLabel("");
            roleFormTitle.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent ev) {
                    PageState ps = ev.getPageState();
                    Label tgt = (Label)ev.getTarget();
                    PortalSite psite = PortalSite.getCurrentPortalSite(ps.getRequest());
                    tgt.setLabel("Grant privilege to a role from the \"" + psite.getTitle() + "\" portal:");
                }
            });
            screen1.add((Component)roleFormTitle);
            RequestLocal rfErrorMessageRL = new RequestLocal();
            SingleSelect roleField = new SingleSelect("roleField");
            roleField.setPrintListener(new PrintListener(){

                public void prepare(PrintEvent ev) {
                    SingleSelect tgt = (SingleSelect)ev.getTarget();
                    PageState ps = ev.getPageState();
                    PortalSite psite = PortalSite.getCurrentPortalSite(ps.getRequest());
                    RoleCollection rc = psite.getRoles();
                    while (rc.next()) {
                        Option o = new Option(rc.getID().toString(), rc.getRoleName());
                        tgt.addOption(o);
                    }
                }
            });
            MyAddGrantForm roleForm = new MyAddGrantForm("roleGrant", (Widget)roleField, rfErrorMessageRL);
            screen1.add((Component)roleForm);
            screen1.add((Component)new ErrorMessageDisplay(rfErrorMessageRL));
            screen1.add((Component)new BoldLabel("Search for a user or role to recieve a privilege:"));
            Form otherSearch = new Form("otherSearch", (Container)new GridPanel(2));
            otherSearch.setRedirecting(true);
            final TextField queryField = new TextField("query");
            otherSearch.add((Component)queryField);
            otherSearch.add((Component)new Submit("Search"));
            Label limitLabel = new Label("");
            limitLabel.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent ev) {
                    Label tgt = (Label)ev.getTarget();
                    PageState ps = ev.getPageState();
                    PortalSite psite = PortalSite.getCurrentPortalSite(ps.getRequest());
                    tgt.setLabel("Limit search to \"" + psite.getTitle() + "\" participants");
                }
            });
            final CheckboxGroup limitToParticipants = new CheckboxGroup("limitToParticipants");
            String[] limitDefault = new String[]{"yes"};
            limitToParticipants.setDefaultValue((Object)limitDefault);
            limitToParticipants.addOption(new Option("yes", (Component)limitLabel));
            otherSearch.add((Component)limitToParticipants);
            otherSearch.add((Component)new Label(""));
            Label noMatchLabel = new Label(GlobalizationUtil.globalize("cw.cw.permissions.no_matches_found")){

                public boolean isVisible(PageState ps) {
                    if (!NewGrantDisplay.this.haveQuery(ps)) {
                        return false;
                    }
                    PartyCollection pc = NewGrantDisplay.this.getQueryResults(ps);
                    return pc != null && pc.size() <= 0L;
                }
            };
            noMatchLabel.setColor(Color.red);
            otherSearch.add((Component)noMatchLabel);
            Label tooManyLabel = new Label(GlobalizationUtil.globalize("cw.cw.permissions.too_many_matches_refine_your_search")){

                public boolean isVisible(PageState ps) {
                    if (!NewGrantDisplay.this.haveQuery(ps)) {
                        return false;
                    }
                    PartyCollection pc = NewGrantDisplay.this.getQueryResults(ps);
                    return pc != null && pc.size() > 20L;
                }
            };
            tooManyLabel.setColor(Color.red);
            otherSearch.add((Component)tooManyLabel);
            BoxPanel screen2 = new BoxPanel(2){

                public boolean isVisible(PageState ps) {
                    if (!NewGrantDisplay.this.haveQuery(ps)) {
                        return false;
                    }
                    PartyCollection pc = NewGrantDisplay.this.getQueryResults(ps);
                    long n = pc.size();
                    return n > 0L && n <= 20L;
                }
            };
            this.add((Component)screen2);
            otherSearch.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent ev) {
                    PageState ps = ev.getPageState();
                    String queryString = (String)queryField.getValue(ps);
                    String[] limit = (String[])limitToParticipants.getValue(ps);
                    if (limit != null && limit.length > 0) {
                        NewGrantDisplay.this.setQuery(ps, queryString, Boolean.TRUE);
                    } else {
                        NewGrantDisplay.this.setQuery(ps, queryString, Boolean.FALSE);
                    }
                }
            });
            screen1.add((Component)otherSearch);
            screen1.add((Component)new Label(""));
            ActionLink returnLink = new ActionLink((String)GlobalizationUtil.globalize("cw.cw.permissions.return_to_current_permissions_view").localize());
            returnLink.setClassAttr("actionLink");
            returnLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    NewGrantDisplay.this.fireCompletionEvent(ev.getPageState());
                }
            });
            screen1.add((Component)returnLink);
            RequestLocal pfErrorMessageRL = new RequestLocal();
            RadioGroup partyField = new RadioGroup("partyField");
            partyField.setLayout(2);
            partyField.setPrintListener(new PrintListener(){

                public void prepare(PrintEvent ev) {
                    PageState ps = ev.getPageState();
                    RadioGroup target = (RadioGroup)ev.getTarget();
                    PartyCollection parties = NewGrantDisplay.this.getQueryResults(ps);
                    while (parties.next()) {
                        target.addOption(new Option(parties.getID().toString(), parties.getDisplayName()));
                    }
                }
            });
            MyAddGrantForm partyForm = new MyAddGrantForm("partyGrant", (Widget)partyField, pfErrorMessageRL);
            screen2.add((Component)partyForm);
            screen2.add((Component)new ErrorMessageDisplay(pfErrorMessageRL));
            ActionLink newSearchLink = new ActionLink((String)GlobalizationUtil.globalize("cw.cw.permissions.try_a_new_search").localize());
            newSearchLink.setClassAttr("actionLink");
            newSearchLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    NewGrantDisplay.this.clearQuery(ev.getPageState());
                }
            });
            screen2.add((Component)newSearchLink);
            ActionLink returnToMainLink = new ActionLink((String)GlobalizationUtil.globalize("cw.cw.permissions.return_to_current_permissions_view").localize());
            returnToMainLink.setClassAttr("actionLink");
            returnToMainLink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    NewGrantDisplay.this.fireCompletionEvent(ev.getPageState());
                }
            });
            screen2.add((Component)returnToMainLink);
        }

        public void fireCompletionEvent(PageState ps) {
            this.clearQuery(ps);
            super.fireCompletionEvent(ps);
        }

        public void register(Page p) {
            p.addComponentStateParam((Component)this, (ParameterModel)this.m_queryParam);
            p.addComponentStateParam((Component)this, (ParameterModel)this.m_limitParam);
            super.register(p);
        }

        private class MyAddGrantForm
        extends AddGrantForm {
            public MyAddGrantForm(String name, Widget partyWidget, RequestLocal errorMessageRL) {
                super(name, (Container)new GridPanel(4), errorMessageRL);
                this.setMethod("post");
                this.add((Component)new BoldLabel("Select Grantee:"));
                this.add((Component)new BoldLabel("On:"){

                    public void generateXML(PageState ps, Element parent) {
                        Collection types = (Collection)NewGrantDisplay.this.m_typesRL.get(ps);
                        if (types == null || types.size() <= 1) {
                            parent.newChildElement("bebop:label", "http://www.arsdigita.com/bebop/1.0");
                            return;
                        }
                        super.generateXML(ps, parent);
                    }
                });
                this.add((Component)new BoldLabel("Privilege:"));
                this.add((Component)new Label(""));
                this.add((Component)new Hidden((ParameterModel)this.getObjectParameter()));
                partyWidget.setParameterModel((ParameterModel)this.getPartyParameter());
                this.add((Component)partyWidget);
                this.add((Component)new TypeSingleSelect((ParameterModel)this.getTypeParameter(), NewGrantDisplay.this.m_typesRL));
                this.add((Component)new PrivilegeSingleSelect((ParameterModel)this.getPrivilegeParameter()));
                this.add((Component)new Submit("Grant"));
                this.addInitListener(new FormInitListener(){

                    public void init(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        FormData fd = ev.getFormData();
                        fd.put((Object)MyAddGrantForm.this.getObjectParameter().getName(), (Object)((ACSObject)NewGrantDisplay.this.m_objectRL.get(ps)).getID());
                    }
                });
                this.addProcessListener(new FormProcessListener(){

                    public void process(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        NewGrantDisplay.this.fireCompletionEvent(ps);
                    }
                });
            }
        }

        private class BoldLabel
        extends Label {
            public BoldLabel(String text) {
                super(text);
                this.setFontWeight("b");
            }
        }
    }

    private class MainDisplay
    extends CompoundComponent {
        MainDisplay(RequestLocal objectRL, RequestLocal directTypesRL, RequestLocal indirectTypesRL, ActionListener onAddClick) {
            super((Container)new BoxPanel(2));
            GridPanel directHeader = new GridPanel(2);
            Label directLabel = new Label(GlobalizationUtil.globalize("cw.cw.permissions.view_and_manage_specific_permissions"));
            directLabel.setFontWeight("b");
            directHeader.add((Component)directLabel, 1);
            ActionLink newGrantLink = new ActionLink((String)GlobalizationUtil.globalize("cw.cw.permissions.add_user_or_role").localize());
            newGrantLink.setClassAttr("actionLink");
            newGrantLink.addActionListener(onAddClick);
            directHeader.add((Component)newGrantLink, 4);
            this.add((Component)directHeader);
            this.add((Component)new Label("The following users and roles have specific privileges on this knowledge item:"));
            ObjectDirectGrantsTable directTable = new ObjectDirectGrantsTable(objectRL, directTypesRL);
            directTable.setCellPadding("5");
            Label directEmptyView = new Label("No specific privileges are defined on this item.");
            directEmptyView.setFontWeight("i");
            directTable.setEmptyView((Component)directEmptyView);
            this.add((Component)directTable);
            this.add((Component)new Label(" "));
            Label indirectLabel = new Label(GlobalizationUtil.globalize("cw.cw.permissions.view_general_permissions"));
            indirectLabel.setFontWeight("b");
            this.add((Component)indirectLabel);
            this.add((Component)new Label("The following users and roles have broader privileges applying to this and other knowledge items.  Note that these are inherited privileges and can only be changed from the location given in the \"On\" column."));
            ObjectIndirectGrantsTable indirectTable = new ObjectIndirectGrantsTable(objectRL, indirectTypesRL);
            indirectTable.setCellPadding("5");
            Label indirectEmpty = new Label("No general permissions apply to this item.");
            indirectEmpty.setFontWeight("i");
            indirectTable.setEmptyView((Component)indirectEmpty);
            this.add((Component)indirectTable);
        }
    }

    private static class ObjectIndirectGrantsTable
    extends ObjectGrantsTable {
        public ObjectIndirectGrantsTable(final RequestLocal objectRL, final RequestLocal typesRL) {
            super(new RequestLocal(){

                public Object initialValue(PageState ps) {
                    DataObject ctx;
                    LinkedList ordering = new LinkedList();
                    ACSObject object = (ACSObject)objectRL.get(ps);
                    Collection types = (Collection)typesRL.get(ps);
                    while (!(object instanceof PortalSite) && (ctx = PermissionService.getContext((ACSObject)object)) != null) {
                        object = (ACSObject)DomainObjectFactory.newInstance((DataObject)ctx);
                        ObjectGrantsTable.getGrantsHelper(object, types, ordering);
                    }
                    return ordering.iterator();
                }
            }, typesRL, false);
            TableColumn targetColumn = new TableColumn(1, (Object)"On");
            targetColumn.setCellRenderer(new TableCellRenderer(){

                public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
                    Grant grant = (Grant)value;
                    Label l = (Label)s_dynamicLabel.get(ps);
                    l.setLabel(grant.objectName);
                    return l;
                }
            });
            this.getColumnModel().add(1, targetColumn);
        }
    }

    private static class ObjectDirectGrantsTable
    extends ObjectGrantsTable {
        public ObjectDirectGrantsTable(final RequestLocal objectRL, final RequestLocal typesRL) {
            super(new RequestLocal(){

                public Object initialValue(PageState ps) {
                    LinkedList ordering = new LinkedList();
                    ObjectGrantsTable.getGrantsHelper((ACSObject)objectRL.get(ps), (Collection)typesRL.get(ps), ordering);
                    return ordering.iterator();
                }
            }, typesRL, true);
        }
    }

    private static class ObjectGrantsTable
    extends GrantsTable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void getGrantsHelper(ACSObject object, Collection types, LinkedList ordering) {
            HashMap<Grant, Grant> canonicalMap = new HashMap<Grant, Grant>();
            ObjectPermissionCollection opc = PermissionService.getDirectGrantedPermissions((OID)object.getOID());
            try {
                while (opc.next()) {
                    s_log.debug((Object)("Current grant in loop is " + opc.getPrivilege()));
                    if (opc.isInherited() || opc.getPrivilege().equals((Object)PrivilegeDescriptor.CREATE)) continue;
                    Grant grant = new Grant();
                    grant.populatePrivilege(opc.getPrivilege());
                    if (grant.level < 0 || grant.objectType != null && types != null && !types.contains(grant.objectType)) continue;
                    grant.granteeID = opc.getGranteeID();
                    grant.granteeName = opc.getGranteeName();
                    grant.granteeIsUser = opc.granteeIsUser();
                    grant.objectID = object.getID();
                    grant.objectName = object.getDisplayName();
                    if (!canonicalMap.containsKey(grant)) {
                        ordering.add(grant);
                        canonicalMap.put(grant, grant);
                        continue;
                    }
                    Grant canonical = (Grant)canonicalMap.get(grant);
                    if (grant.level <= canonical.level) continue;
                    canonical.level = grant.level;
                    canonical.basePrivilege = grant.basePrivilege;
                }
            }
            finally {
                opc.close();
            }
        }

        public ObjectGrantsTable(RequestLocal grantsRL, RequestLocal typesRL, boolean isEditable) {
            super(grantsRL, typesRL, isEditable);
            TableColumn partyColumn = new TableColumn(0, (Object)"User or Role");
            partyColumn.setCellRenderer(new TableCellRenderer(){
                final RequestLocal m_userNameDisplay = new RequestLocal(){

                    public Object initialValue(PageState ps) {
                        SimpleContainer result = new SimpleContainer();
                        result.add((Component)Icons.USER_16);
                        result.add((Component)s_dynamicLabel.get(ps));
                        return result;
                    }
                };
                final RequestLocal m_groupNameDisplay = new RequestLocal(){

                    public Object initialValue(PageState ps) {
                        SimpleContainer result = new SimpleContainer();
                        result.add((Component)Icons.GROUP_16);
                        result.add((Component)s_dynamicLabel.get(ps));
                        return result;
                    }
                };

                public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
                    Grant grant = (Grant)value;
                    Label nameLabel = (Label)s_dynamicLabel.get(ps);
                    nameLabel.setLabel((String)GlobalizationUtil.globalize("cw.cw.permissions.").localize() + grant.granteeName);
                    if (grant.granteeIsUser) {
                        return (Component)this.m_userNameDisplay.get(ps);
                    }
                    return (Component)this.m_groupNameDisplay.get(ps);
                }
            });
            this.getColumnModel().add(0, partyColumn);
        }
    }
}

