/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.permissions;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.permissions.AddGrantForm;
import com.arsdigita.portalserver.permissions.ErrorMessageDisplay;
import com.arsdigita.portalserver.permissions.Grant;
import com.arsdigita.portalserver.permissions.GrantsTable;
import com.arsdigita.portalserver.permissions.PrivilegeSingleSelect;
import com.arsdigita.portalserver.permissions.TypeSingleSelect;
import com.arsdigita.portalserver.permissions.util.GlobalizationUtil;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class PartyPermissionEdit
extends CompoundComponent {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/permissions/PartyPermissionEdit.java#3 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)PartyPermissionEdit.class.getName());
    private static final RequestLocal s_dynamicLabel = new RequestLocal(){

        public Object initialValue(PageState ps) {
            return new Label();
        }
    };

    public PartyPermissionEdit(String title, RequestLocal portalsiteRL, RequestLocal partyRL) {
        super((Container)new ModalContainer());
        final ModalContainer container = (ModalContainer)this.getContainer();
        final BoxPanel mainDisplay = new BoxPanel();
        mainDisplay.setWidth("100%");
        container.add((Component)mainDisplay);
        container.setDefaultComponent((Component)mainDisplay);
        ActionListener returnToMain = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                container.setVisibleComponent(ev.getPageState(), (Component)mainDisplay);
            }
        };
        final MyAddGrantForm addForm = new MyAddGrantForm(portalsiteRL, partyRL, new RequestLocal(), returnToMain);
        container.add((Component)addForm);
        GridPanel header = new GridPanel(2);
        Label titleLabel = new Label(title);
        titleLabel.setFontWeight("b");
        header.add((Component)titleLabel, 1);
        ActionLink grantLink = new ActionLink((String)GlobalizationUtil.globalize("cw.cw.permissions.add_a_privilege").localize());
        grantLink.setClassAttr("actionLink");
        grantLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                container.setVisibleComponent(ev.getPageState(), (Component)addForm);
            }
        });
        header.add((Component)grantLink, 4);
        mainDisplay.add((Component)header);
        mainDisplay.add((Component)new PartyGrantsTable(portalsiteRL, partyRL, new RequestLocal()));
    }

    private static class MyAddGrantForm
    extends AddGrantForm {
        private RequestLocal m_portalsiteRL;
        private RequestLocal m_partyRL;
        private RequestLocal m_typesRL;
        private RequestLocal m_errorMessageRL;
        private ActionListener m_onComplete;
        private RequestLocal m_targetsRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                ArrayList<Option> result = new ArrayList<Option>();
                Party party = (Party)MyAddGrantForm.this.m_partyRL.get(ps);
                PortalSite psite = (PortalSite)((Object)MyAddGrantForm.this.m_portalsiteRL.get(ps));
                PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)psite, party);
                if (!PermissionService.checkDirectPermission((PermissionDescriptor)perm)) {
                    result.add(new Option(psite.getID().toString(), psite.getDisplayName()));
                }
                ApplicationCollection ac = psite.getFullPagePortalSiteApplications();
                while (ac.next()) {
                    Application app = ac.getApplication();
                    perm = new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)app, party);
                    if (PermissionService.checkDirectPermission((PermissionDescriptor)perm)) continue;
                    result.add(new Option(app.getID().toString(), app.getDisplayName()));
                }
                return result;
            }
        };
        private Submit m_cancel = new Submit("Return");

        private MyAddGrantForm(RequestLocal portalsiteRL, RequestLocal partyRL, RequestLocal typesRL, RequestLocal errorMessageRL, ActionListener onComplete) {
            super("addGrant", (Container)new BoxPanel(), errorMessageRL);
            this.setMethod("post");
            this.m_portalsiteRL = portalsiteRL;
            this.m_partyRL = partyRL;
            this.m_typesRL = typesRL;
            this.m_errorMessageRL = errorMessageRL;
            this.m_onComplete = onComplete;
            final GridPanel widgets = new GridPanel(4);
            widgets.add((Component)new BoldLabel("Select Target:"));
            widgets.add((Component)new BoldLabel("On:"){

                public void generateXML(PageState ps, Element parent) {
                    Collection types = (Collection)MyAddGrantForm.this.m_typesRL.get(ps);
                    if (types == null || types.size() <= 1) {
                        parent.newChildElement("bebop:label", "http://www.arsdigita.com/bebop/1.0");
                        return;
                    }
                    super.generateXML(ps, parent);
                }
            });
            widgets.add((Component)new BoldLabel("Privilege:"));
            widgets.add((Component)new Label(""));
            this.add((Component)new Hidden((ParameterModel)this.getPartyParameter()));
            SingleSelect objectSelect = new SingleSelect((ParameterModel)this.getObjectParameter());
            objectSelect.setPrintListener(new PrintListener(){

                public void prepare(PrintEvent ev) {
                    SingleSelect target = (SingleSelect)ev.getTarget();
                    PageState ps = ev.getPageState();
                    List options = (List)MyAddGrantForm.this.m_targetsRL.get(ps);
                    Iterator it = options.iterator();
                    while (it.hasNext()) {
                        target.addOption((Option)it.next());
                    }
                }
            });
            widgets.add((Component)objectSelect);
            widgets.add((Component)new TypeSingleSelect((ParameterModel)this.getTypeParameter(), typesRL));
            widgets.add((Component)new PrivilegeSingleSelect((ParameterModel)this.getPrivilegeParameter()));
            Submit grant = new Submit("Grant");
            widgets.add((Component)grant);
            this.add((Component)widgets);
            this.add((Component)new ErrorMessageDisplay(errorMessageRL));
            this.add((Component)this.m_cancel);
            this.addSubmissionListener(new FormSubmissionListener(){

                public void submitted(FormSectionEvent evt) throws FormProcessException {
                    PageState ps = evt.getPageState();
                    if (MyAddGrantForm.this.m_cancel.isSelected(ps)) {
                        ps.reset((Component)MyAddGrantForm.this);
                        MyAddGrantForm.this.m_onComplete.actionPerformed(new ActionEvent((Component)MyAddGrantForm.this, ps));
                        throw new FormProcessException("cancel");
                    }
                }
            });
            this.addInitListener(new FormInitListener(){

                public void init(FormSectionEvent ev) throws FormProcessException {
                    PageState ps = ev.getPageState();
                    FormData fd = ev.getFormData();
                    fd.put((Object)MyAddGrantForm.this.getPartyParameter().getName(), (Object)((Party)MyAddGrantForm.this.m_partyRL.get(ps)).getID());
                    List targets = (List)MyAddGrantForm.this.m_targetsRL.get(ps);
                    if (targets.size() == 0) {
                        widgets.setVisible(ps, false);
                        MyAddGrantForm.this.m_cancel.setVisible(ps, true);
                        throw new FormValidationException("There are no objects that this party can be granted permission on.");
                    }
                }
            });
        }

        public MyAddGrantForm(RequestLocal portalsiteRL, RequestLocal partyRL, RequestLocal typesRL, ActionListener onComplete) {
            this(portalsiteRL, partyRL, typesRL, new RequestLocal(), onComplete);
        }

        public void register(Page p) {
            super.register(p);
            p.setVisibleDefault((Component)this.m_cancel, false);
        }

        @Override
        protected void fireProcess(FormSectionEvent evt) throws FormProcessException {
            super.fireProcess(evt);
            PageState ps = evt.getPageState();
            this.m_onComplete.actionPerformed(new ActionEvent((Component)this, ps));
        }
    }

    private static class BoldLabel
    extends Label {
        public BoldLabel(String text) {
            super(text);
            this.setFontWeight("b");
        }
    }

    private static class PartyGrantsTable
    extends GrantsTable {
        static void getGrantsHelper(Party party, Application application, Collection types, LinkedList ordering) {
            HashMap<Grant, Grant> canonicalMap = new HashMap<Grant, Grant>();
            Iterator privIter = PermissionService.getDirectPrivileges((OID)application.getOID(), (OID)party.getOID());
            while (privIter.hasNext()) {
                Grant grant = new Grant();
                PrivilegeDescriptor priv = (PrivilegeDescriptor)privIter.next();
                s_log.debug((Object)("Current grant in loop is " + priv));
                if (priv.equals((Object)PrivilegeDescriptor.CREATE)) continue;
                grant.populatePrivilege(priv);
                if (grant.level < 0 || grant.objectType != null && types != null && !types.contains(grant.objectType)) continue;
                grant.granteeID = party.getID();
                grant.granteeName = party.getName();
                grant.granteeIsUser = party instanceof User;
                grant.objectID = application.getID();
                grant.objectName = application.getDisplayName();
                if (!canonicalMap.containsKey(grant)) {
                    ordering.add(grant);
                    canonicalMap.put(grant, grant);
                    continue;
                }
                Grant canonical = (Grant)canonicalMap.get(grant);
                if (grant.level <= canonical.level) continue;
                canonical.level = grant.level;
                canonical.basePrivilege = grant.basePrivilege;
            }
        }

        public PartyGrantsTable(final RequestLocal portalsiteRL, final RequestLocal partyRL, final RequestLocal typesRL) {
            super(new RequestLocal(){

                public Object initialValue(PageState ps) {
                    LinkedList ordering = new LinkedList();
                    PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                    Party party = (Party)partyRL.get(ps);
                    Collection types = (Collection)typesRL.get(ps);
                    PartyGrantsTable.getGrantsHelper(party, psite, types, ordering);
                    ApplicationCollection ac = psite.getFullPagePortalSiteApplications();
                    while (ac.next()) {
                        PartyGrantsTable.getGrantsHelper(party, ac.getApplication(), types, ordering);
                    }
                    return ordering.iterator();
                }
            }, typesRL, true);
            TableColumn appColumn = new TableColumn(0, (Object)"On:");
            appColumn.setCellRenderer(new TableCellRenderer(){

                public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int col) {
                    Grant grant = (Grant)value;
                    Label l = (Label)s_dynamicLabel.get(ps);
                    l.setLabel(grant.objectName);
                    return l;
                }
            });
            appColumn.setWidth("150");
            this.getColumnModel().add(0, appColumn);
        }
    }
}

