/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.portal.PortalModel;
import com.arsdigita.bebop.portal.PortalModelBuilder;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portal.DefaultPortalModel;
import com.arsdigita.portal.Portal;
import com.arsdigita.portalserver.LoggedInLinkWrapper;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.PortalTabCollection;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PortalHomePage
extends PortalPage {
    private static final Logger s_log = Logger.getLogger(PortalHomePage.class);
    private static final Cookie[] EMPTY_COOKIES = new Cookie[0];
    public static final String PORTAL_XML_NS = "http://www.arsdigita.com/portalserver/1.0";
    List m_tabs;
    private RequestLocal m_hasAdmin = new RequestLocal(){

        public Object initialValue(PageState ps) {
            PortalSite psite = PortalSite.getCurrentPortalSite(ps.getRequest());
            if (psite.checkPrivilege(PrivilegeDescriptor.ADMIN)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    public PortalHomePage() {
        this.addRequestListener(new PortalRequestListener());
        this.lock();
    }

    private boolean hasAdmin(PageState ps) {
        return this.m_hasAdmin.get(ps).equals(Boolean.TRUE);
    }

    protected PortalSite getPortalSite(PageState pageState) {
        return PortalSite.getCurrentPortalSite(pageState.getRequest());
    }

    @Override
    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new LoggedInLinkWrapper(new PortalPage.PersonalPortalLinkPrinter()));
        navbar.add((Component)new Label((PrintListener)new PortalPage.CurrentPortalLabelPrinter()));
        this.getHeader().add((Component)navbar);
    }

    @Override
    protected void buildHeader(Container header) {
        Link adminLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.configure_workspace")), "./admin"){

            public boolean isVisible(PageState ps) {
                return PortalHomePage.this.hasAdmin(ps);
            }
        };
        adminLink.setClassAttr("portalControl");
        header.add((Component)adminLink);
        class SearchComponent
        extends SimpleContainer {
            SearchComponent() {
            }

            public void generateXML(PageState state, Element parent) {
            }
        }
        header.add((Component)new SearchComponent());
    }

    @Override
    protected void buildBody(Container body) {
        ListModelBuilder lmb = new ListModelBuilder(){
            boolean m_isLocked;

            public ListModel makeModel(List l, PageState pageState) {
                return new TabsListModel(pageState);
            }

            public void lock() {
                this.m_isLocked = true;
            }

            public boolean isLocked() {
                return this.m_isLocked;
            }
        };
        this.m_tabs = new List(lmb);
        this.m_tabs.setClassAttr("portalTabs");
        this.m_tabs.setCellRenderer((ListCellRenderer)new TabsListCellRenderer());
        this.m_tabs.addChangeListener((ChangeListener)new CookieChangeListener());
        body.add((Component)this.m_tabs);
    }

    private class CookieChangeListener
    implements ChangeListener {
        private CookieChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            PageState ps = e.getPageState();
            PortalSite psite = PortalHomePage.this.getPortalSite(ps);
            Assert.exists((Object)((Object)psite), (String)"workspace");
            HttpServletResponse response = ps.getResponse();
            String cookieNameString = "prtl_" + psite.getID().toString();
            String tabName = (String)PortalHomePage.this.m_tabs.getSelectedKey(ps);
            Cookie cookie = new Cookie(cookieNameString, tabName);
            cookie.setMaxAge(36000);
            cookie.setComment("This cookie returns you to the tab you had open when you last visited this portal.");
            response.addCookie(cookie);
        }
    }

    class PortalTabsModelBuilder
    implements PortalModelBuilder {
        PortalTab m_ptab;

        PortalTabsModelBuilder(PortalTab ptab) {
            this.m_ptab = ptab;
        }

        public PortalModel buildModel(PageState pageState) {
            return new DefaultPortalModel((Portal)this.m_ptab);
        }
    }

    class TabsListCellRenderer
    implements ListCellRenderer {
        TabsListCellRenderer() {
        }

        public Component getComponent(List list, PageState pageState, Object value, String key, int index, boolean isSelected) {
            PortalTab ptab = (PortalTab)((Object)value);
            if (isSelected) {
                String layout = ptab.getLayout();
                com.arsdigita.bebop.portal.Portal port = new com.arsdigita.bebop.portal.Portal((PortalModelBuilder)new PortalTabsModelBuilder(ptab));
                port.setStyleAttr(layout.toUpperCase());
                return port;
            }
            return new ControlLink(ptab.getTitle());
        }
    }

    private class TabsListModel
    implements ListModel {
        PortalTabCollection ptabs = null;
        PortalTab ptab = null;

        TabsListModel(PageState pageState) {
            PortalSite psite = PortalHomePage.this.getPortalSite(pageState);
            this.ptabs = psite.getTabsForPortalSite();
        }

        public boolean next() {
            return this.ptabs.next();
        }

        public Object getElement() {
            return this.ptabs.getPortalTab();
        }

        public String getKey() {
            return this.ptabs.getID().toString();
        }

        public void close() {
            this.ptabs.close();
        }

        public void reset() {
            this.ptabs.rewind();
        }
    }

    private class PortalRequestListener
    implements RequestListener {
        private PortalRequestListener() {
        }

        public void pageRequested(RequestEvent e) {
            PageState ps = e.getPageState();
            boolean notFound = true;
            PortalSite portalsite = PortalHomePage.this.getPortalSite(ps);
            Assert.exists((Object)((Object)portalsite), (String)"workspace");
            if (!portalsite.isReady()) {
                // empty if block
            }
            if (!PortalHomePage.this.m_tabs.isSelected(ps)) {
                String prtlID = portalsite.getID().toString();
                String cookiePRTLName = "prtl_" + prtlID;
                HttpServletRequest httpRequest = ps.getRequest();
                Cookie[] cookies = this.getCookies(httpRequest);
                String result = this.getCookieValue(cookies, cookiePRTLName);
                TabsListModel tlm = new TabsListModel(ps);
                if (result != null) {
                    while (tlm.next()) {
                        String tmpstr = tlm.getKey();
                        if (!result.equals(tmpstr)) continue;
                        PortalHomePage.this.m_tabs.setSelectedKey(ps, tmpstr);
                        notFound = false;
                        break;
                    }
                    if (notFound) {
                        tlm.reset();
                        if (tlm.next()) {
                            String key = tlm.getKey();
                            PortalHomePage.this.m_tabs.setSelectedKey(ps, key);
                        }
                    }
                } else if (tlm.next()) {
                    String key = tlm.getKey();
                    PortalHomePage.this.m_tabs.setSelectedKey(ps, key);
                }
                tlm.close();
            }
        }

        private Cookie[] getCookies(HttpServletRequest httpRequest) {
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies == null) {
                return EMPTY_COOKIES;
            }
            return cookies;
        }

        public String getCookieValue(Cookie[] cookies, String cookieName) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
            return null;
        }
    }
}

