/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.portalserver.ApplicationAuthenticationListener;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.admin.ApplicationsPane;
import com.arsdigita.portalserver.ui.admin.BasicPane;
import com.arsdigita.portalserver.ui.admin.DisplayPane;
import com.arsdigita.portalserver.ui.admin.PeoplePane;
import com.arsdigita.portalserver.ui.admin.RelatedPortalsPane;
import com.arsdigita.portalserver.ui.admin.ThemesPane;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import org.apache.log4j.Category;

public class PortalAdminPage
extends PortalPage {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/PortalAdminPage.java#8 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)PortalAdminPage.class.getName());
    RequestLocal m_portalsiteRL;

    public PortalAdminPage() {
        this.setClassAttr("portalserveradmin");
        this.getHeader().setIdAttr("admin");
        this.m_portalsiteRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                return PortalSite.getCurrentPortalSite(ps.getRequest());
            }
        };
        this.addRequestListener(new ApplicationAuthenticationListener("admin"));
        this.lock();
    }

    @Override
    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new Link((PrintListener)new PortalPage.PersonalPortalLinkPrinter()));
        navbar.add((Component)new Link((PrintListener)new PortalPage.CurrentPortalLinkPrinter()));
        navbar.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.configure_workspace")));
        this.getHeader().add((Component)navbar);
    }

    @Override
    protected void buildHeader(Container header) {
        Link returnLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.return_to_workspace")), "../");
        returnLink.setClassAttr("portalControl");
        header.add((Component)returnLink);
    }

    @Override
    protected void buildBody(Container body) {
        TabbedPane pane = new TabbedPane();
        pane.setClassAttr("portalserver_admin");
        pane.addTab("Layout", (Component)new DisplayPane(this.m_portalsiteRL));
        pane.addTab("Themes", (Component)new ThemesPane(this.m_portalsiteRL));
        pane.addTab("Applications", ApplicationsPane.create(this.m_portalsiteRL));
        pane.addTab("People", PeoplePane.create(this, this.m_portalsiteRL));
        pane.addTab("Related Portals", RelatedPortalsPane.create(this.m_portalsiteRL));
        pane.addTab("Basic Properties", BasicPane.create(this.m_portalsiteRL));
        body.add((Component)pane);
        body.setClassAttr("portalserver_admin");
    }

    @Override
    public void addStyleBlock(PageState state, Document parent) {
        PortalSite psite = PortalSite.getCurrentPortalSite(state.getRequest());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<STYLE type=\"text/css\"> <!--");
        buffer.append(" table.globalHeader { background-color: rgb(225,225,225);} ");
        buffer.append(" table.bottomRule { background: rgb(162,30,30);} ");
        buffer.append(" table.topRuleNoTabs { background: rgb(162,30,30);} ");
        buffer.append("--></STYLE>");
        Element rootElement = parent.getRootElement();
        Element styleBlock = rootElement.newChildElement("portalserver:styleblock", "http://www.redhat.com/portalserver/1.0");
        styleBlock.setCDATASection(buffer.toString());
    }
}

