/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SplitPanel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.admin.PortalCreateForm;
import com.arsdigita.portalserver.ui.admin.PortalTreeModelBuilder;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TooManyListenersException;

public final class PortalSiteMapPanel
extends SplitPanel {
    Tree m_portalTree;
    PortalTreeModelBuilder m_portalTreeModelBuilder;
    Label m_noPortalSelected;
    ArchiveForm archiveForm;
    UnarchiveForm unarchiveForm;
    PropertiesForm propForm;
    EditPropertiesForm editpropForm;
    DeleteForm deleteform;
    Component createform;
    Component createchildform;
    GridPanel vmdPanel;
    GridPanel linkPanel;
    RequestLocal m_selectedPortalRL;
    RequestLocal portalsiteRL;
    RequestLocal childportalsiteRL;

    public PortalSiteMapPanel(Page p) {
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState s = e.getPageState();
                if (!PortalSiteMapPanel.this.m_portalTree.isSelected(s)) {
                    PortalSiteMapPanel.this.clearAllVisibility(s);
                    PortalSiteMapPanel.this.linkPanel.setVisible(s, true);
                    PortalSiteMapPanel.this.m_noPortalSelected.setVisible(s, true);
                }
            }
        });
        this.portalsiteRL = new RequestLocal();
        this.childportalsiteRL = new RequestLocal();
        this.m_selectedPortalRL = new RequestLocal(){

            protected Object initialValue(PageState s) {
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s)) {
                    String portalIDstr = (String)PortalSiteMapPanel.this.m_portalTree.getSelectionModel().getSelectedKey(s);
                    return PortalSite.retrievePortalSite(new BigDecimal(portalIDstr));
                }
                return null;
            }
        };
        this.setClassAttr("portalsitemap");
        this.setDivider(40);
        GridPanel headerPanel = new GridPanel(1);
        headerPanel.setClassAttr("portalsitemap_header");
        headerPanel.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_archive_header")));
        this.setHeader((Component)headerPanel);
        GridPanel portalPanel = new GridPanel(1);
        portalPanel.setClassAttr("portalsitemap_panel");
        this.setLeftComponent((Component)portalPanel);
        GridPanel RHSPanel = new GridPanel(1);
        GridPanel formPanel = new GridPanel(1);
        GridPanel actionPanel = new GridPanel(1);
        this.linkPanel = new GridPanel(4);
        this.linkPanel.setClassAttr("portalsitemaplinkpanel");
        this.setRightComponent((Component)RHSPanel);
        RHSPanel.add((Component)formPanel);
        RHSPanel.add((Component)actionPanel);
        this.archiveForm = new ArchiveForm();
        actionPanel.add((Component)this.archiveForm);
        this.unarchiveForm = new UnarchiveForm();
        actionPanel.add((Component)this.unarchiveForm);
        GridPanel gp0 = new GridPanel(1);
        gp0.setClassAttr("deleteform");
        this.deleteform = new DeleteForm(gp0);
        actionPanel.add((Component)this.deleteform);
        actionPanel.add((Component)this.linkPanel);
        GridPanel gp1 = new GridPanel(1);
        gp1.setClassAttr("propertiesform");
        this.propForm = new PropertiesForm(gp1);
        formPanel.add((Component)this.propForm);
        GridPanel gp2 = new GridPanel(1);
        gp2.setClassAttr("editpropscontainer");
        this.editpropForm = new EditPropertiesForm(gp2);
        formPanel.add((Component)this.editpropForm);
        this.vmdPanel = new GridPanel(3){

            public boolean isVisible(PageState s) {
                return PortalSiteMapPanel.this.m_portalTree.isSelected(s);
            }
        };
        this.vmdPanel.setClassAttr("portalsitemaplinkpanelvmd");
        this.linkPanel.add((Component)this.vmdPanel);
        this.createform = PortalCreateForm.create(new RequestLocal(), this.portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
            }
        });
        formPanel.add(this.createform);
        this.createchildform = PortalCreateForm.create(this.m_selectedPortalRL, this.childportalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
            }
        });
        formPanel.add(this.createchildform);
        this.m_portalTreeModelBuilder = new PortalTreeModelBuilder(false);
        this.m_portalTree = new Tree((TreeModelBuilder)this.m_portalTreeModelBuilder);
        this.m_portalTree.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState s = e.getPageState();
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s)) {
                    PortalSiteMapPanel.this.clearAllVisibility(s);
                    PortalSiteMapPanel.this.propForm.setVisible(s, true);
                    PortalSiteMapPanel.this.linkPanel.setVisible(s, true);
                    PortalSiteMapPanel.this.vmdPanel.setVisible(s, true);
                } else {
                    PortalSiteMapPanel.this.clearAllVisibility(s);
                    PortalSiteMapPanel.this.m_noPortalSelected.setVisible(s, true);
                }
            }
        });
        this.m_portalTree.setCellRenderer((TreeCellRenderer)new PortalTreeModelBuilder.DefaultRenderer());
        this.m_portalTree.setClassAttr("portalsitemap_tree");
        Label sitemaplabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portals_currently_mounted"));
        sitemaplabel.setFontWeight("b");
        portalPanel.add((Component)sitemaplabel);
        portalPanel.add((Component)this.m_portalTree);
        ActionLink createtoplevel = new ActionLink((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.create_top_level")));
        createtoplevel.setClassAttr("createtoplevel");
        createtoplevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortalSite psite;
                PageState s = e.getPageState();
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                    PortalSiteMapPanel.this.clearAllVisibility(s);
                    PortalSiteMapPanel.this.createform.setVisible(s, true);
                }
            }
        });
        ActionLink createchild = new ActionLink((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.create_child"))){

            public boolean isVisible(PageState s) {
                return PortalSiteMapPanel.this.m_portalTree.isSelected(s);
            }
        };
        createchild.setClassAttr("createchild");
        createchild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortalSite psite;
                PageState s = e.getPageState();
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                    PortalSiteMapPanel.this.clearAllVisibility(s);
                    PortalSiteMapPanel.this.createchildform.setVisible(s, true);
                }
            }
        });
        Label createPanelLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.create"));
        createPanelLabel.setIdAttr("createpanelheader");
        this.linkPanel.add((Component)createPanelLabel);
        this.linkPanel.add((Component)createtoplevel);
        this.linkPanel.add((Component)createchild);
        Link visitbutton = new Link("Visit selected portal", "");
        visitbutton.setClassAttr("portalvisitlink");
        try {
            visitbutton.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s)) {
                        PortalSite psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s));
                        Link l = (Link)e.getTarget();
                        if (psite != null) {
                            l.setTarget(psite.getPath());
                        } else {
                            l.setTarget("");
                        }
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            // empty catch block
        }
        Link visitadminbutton = new Link("Visit selected portal admin page", "");
        visitadminbutton.setClassAttr("portaladminvisitlink");
        try {
            visitadminbutton.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s)) {
                        PortalSite psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s));
                        Link l = (Link)e.getTarget();
                        if (psite != null) {
                            l.setTarget(psite.getPath() + "/admin/");
                        } else {
                            l.setTarget("");
                        }
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            // empty catch block
        }
        Label viewLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.viewpanel_header"));
        viewLabel.setIdAttr("viewpanelheader");
        this.vmdPanel.add((Component)viewLabel);
        this.vmdPanel.add((Component)visitbutton);
        this.vmdPanel.add((Component)visitadminbutton);
        Label archivelinklabel = new Label("Archive/Unarchive");
        archivelinklabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PortalSite psite;
                PageState s = e.getPageState();
                Label t = (Label)e.getTarget();
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                    if (psite.isArchived()) {
                        t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.unarchive"));
                    } else {
                        t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.archive"));
                    }
                }
            }
        });
        ActionLink archivebutton = new ActionLink((Component)archivelinklabel);
        archivebutton.setClassAttr("portalarchivelink");
        archivebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortalSite psite;
                PageState s = e.getPageState();
                if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                    if (psite.isArchived()) {
                        PortalSiteMapPanel.this.clearAllVisibility(s);
                        PortalSiteMapPanel.this.unarchiveForm.setVisible(s, true);
                        PortalSiteMapPanel.this.propForm.setVisible(s, true);
                    } else {
                        PortalSiteMapPanel.this.clearAllVisibility(s);
                        PortalSiteMapPanel.this.archiveForm.setVisible(s, true);
                        PortalSiteMapPanel.this.propForm.setVisible(s, true);
                    }
                }
            }
        });
        Label modifyLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.modifypanel_header"));
        modifyLabel.setIdAttr("modifypanelheader");
        this.vmdPanel.add((Component)modifyLabel);
        this.vmdPanel.add((Component)archivebutton);
        ActionLink deletebutton = new ActionLink("Delete");
        deletebutton.setClassAttr("portaldeletelink");
        deletebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                PortalSiteMapPanel.this.clearAllVisibility(s);
                PortalSiteMapPanel.this.deleteform.setVisible(s, true);
                PortalSiteMapPanel.this.propForm.setVisible(s, true);
            }
        });
        Label deleteLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.deletepanel_header"));
        deleteLabel.setIdAttr("deletepanelheader");
        this.vmdPanel.add((Component)deleteLabel);
        this.vmdPanel.add((Component)deletebutton);
        this.m_noPortalSelected = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_portal_selected"));
        this.m_noPortalSelected.setFontWeight("i");
        formPanel.add((Component)this.m_noPortalSelected);
    }

    public void clearAllVisibility(PageState s) {
        this.propForm.setVisible(s, false);
        this.editpropForm.setVisible(s, false);
        this.createform.setVisible(s, false);
        this.createchildform.setVisible(s, false);
        this.linkPanel.setVisible(s, false);
        this.vmdPanel.setVisible(s, false);
        this.archiveForm.setVisible(s, false);
        this.unarchiveForm.setVisible(s, false);
        this.deleteform.setVisible(s, false);
        this.m_noPortalSelected.setVisible(s, false);
    }

    public class DeleteForm
    extends Form
    implements FormProcessListener {
        private Label instruction3;
        private Label instruction1;
        private Label deleteTableHeader1;
        private Label deleteTableHeader2;
        private Label deleteTableHeader3;
        private Submit button;
        private Submit cancelbutton;
        PortalSite psite;
        PageState s;
        CheckboxGroup checkGroup;
        List list;
        ArrayParameter params;
        private static final String APP_LIST = "delete-form-app-choices";

        public DeleteForm(GridPanel gp) {
            super("deleteform", (Container)gp);
            this.params = new ArrayParameter((ParameterModel)new BigDecimalParameter(APP_LIST));
            this.checkGroup = new CheckboxGroup(APP_LIST);
            this.list = new List(new ListModelBuilder(){

                public ListModel makeModel(List l, PageState s) {
                    PortalSite psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s));
                    return new AppListModel(psite);
                }

                public void lock() {
                }

                public boolean isLocked() {
                    return true;
                }
            });
            this.list.setIdAttr("deleteappslist");
            this.list.setCellRenderer(new ListCellRenderer(){

                public Component getComponent(List l, PageState s, Object value, String key, int index, boolean isSelected) {
                    SimpleContainer container = new SimpleContainer();
                    container.setIdAttr("deleteapplist");
                    Label type = null;
                    Option newOption = new Option(key, "");
                    newOption.setGroup((OptionGroup)DeleteForm.this.checkGroup);
                    Label name = new Label((String)value);
                    name.setIdAttr("deleteappname");
                    Application app = Application.retrieveApplication((BigDecimal)new BigDecimal(key));
                    if (app != null) {
                        type = new Label(app.getApplicationType().getTitle());
                        type.setIdAttr("deleteapptype");
                    }
                    container.add((Component)newOption);
                    container.add((Component)name);
                    if (type != null) {
                        container.add((Component)type);
                    }
                    return container;
                }
            });
            this.deleteTableHeader1 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_table_header1"));
            this.deleteTableHeader1.setIdAttr("deletetableheader1");
            this.deleteTableHeader2 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_table_header2"));
            this.deleteTableHeader2.setIdAttr("deletetableheader2");
            this.deleteTableHeader3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_table_header3"));
            this.deleteTableHeader3.setIdAttr("deletetableheader3");
            this.instruction1 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_instruction1"));
            this.instruction1.setIdAttr("delete_instruction1");
            this.instruction3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_this_portal"));
            this.instruction3.setIdAttr("delete_instruction3");
            this.button = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.delete"));
            this.button.setIdAttr("deleteformbutton");
            this.cancelbutton = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.cancelbutton.setIdAttr("deleteformcancelbutton");
            this.add((Component)this.instruction1);
            this.add((Component)this.instruction3);
            this.add((Component)this.deleteTableHeader1);
            this.add((Component)this.deleteTableHeader2);
            this.add((Component)this.deleteTableHeader3);
            this.add((Component)new Label(""));
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.add((Component)this.checkGroup);
            this.add((Component)this.list);
            this.addProcessListener(this);
        }

        public void register(Page p) {
            super.register(p);
            p.addComponentStateParam((Component)this, (ParameterModel)this.params);
        }

        public void process(FormSectionEvent e) {
            this.s = e.getPageState();
            if (this.button.isSelected(this.s)) {
                KernelExcursion ex = new KernelExcursion(){

                    protected void excurse() {
                        String[] selectedApps = (String[])DeleteForm.this.checkGroup.getValue(DeleteForm.this.s);
                        if (selectedApps != null) {
                            for (int i = 0; i < selectedApps.length; ++i) {
                                Application deadApp = Application.retrieveApplication((BigDecimal)new BigDecimal(selectedApps[i]));
                                deadApp.delete();
                            }
                        }
                        DeleteForm.this.psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(DeleteForm.this.s));
                        this.setEffectiveParty(Kernel.getSystemParty());
                        DeleteForm.this.psite.delete();
                    }
                };
                ex.run();
                PortalSiteMapPanel.this.clearAllVisibility(this.s);
                PortalSiteMapPanel.this.m_portalTree.clearSelection(this.s);
                this.setVisible(this.s, false);
                PortalSiteMapPanel.this.m_noPortalSelected.setVisible(this.s, true);
                PortalSiteMapPanel.this.linkPanel.setVisible(this.s, true);
            } else {
                PortalSiteMapPanel.this.clearAllVisibility(this.s);
                this.setVisible(this.s, false);
                PortalSiteMapPanel.this.propForm.setVisible(this.s, true);
                PortalSiteMapPanel.this.linkPanel.setVisible(this.s, true);
                PortalSiteMapPanel.this.vmdPanel.setVisible(this.s, true);
            }
        }

        public class AppListModel
        implements ListModel {
            ApplicationCollection m_apps;
            Application m_app;

            public AppListModel(PortalSite psite) {
                this.m_apps = psite.getFullPagePortalSiteApplications();
            }

            public boolean next() {
                if (!this.m_apps.next()) {
                    return false;
                }
                this.m_app = this.m_apps.getApplication();
                return true;
            }

            public Object getElement() {
                return this.m_app.getTitle();
            }

            public String getKey() {
                return this.m_app.getID().toString();
            }
        }
    }

    public class EditPropertiesForm
    extends Form
    implements FormProcessListener {
        private Label heading;
        private Label nameLabel;
        private TextField name;
        private Label descriptionLabel;
        private TextArea description;
        private Submit update;
        private Submit cancel;

        EditPropertiesForm(GridPanel gp) {
            super("editpropsform", (Container)gp);
            this.heading = new Label("Editable Properties");
            this.heading.setIdAttr("editpropnameselected");
            this.heading.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        String n = psite.getDisplayName();
                        Label t = (Label)e.getTarget();
                        t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.edit_props").localize(s.getRequest()) + " " + n);
                    }
                }
            });
            this.add((Component)this.heading);
            this.nameLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_name"));
            this.nameLabel.setIdAttr("editpropnamelabel");
            this.name = new TextField("portalname");
            this.name.setIdAttr("editpropname");
            this.name.addValidationListener((ParameterListener)new NotNullValidationListener(GlobalizationUtil.globalize("cw.workspace.ui.admin.need_portal_name")));
            try {
                this.name.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PortalSite psite;
                        PageState s = e.getPageState();
                        if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                            String n = psite.getDisplayName();
                            TextField tf = (TextField)e.getTarget();
                            tf.setValue(s, (Object)n);
                        }
                    }
                });
            }
            catch (TooManyListenersException e) {
                // empty catch block
            }
            this.add((Component)this.nameLabel);
            this.add((Component)this.name);
            this.descriptionLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_desc"));
            this.descriptionLabel.setIdAttr("editpropdescriptionlabel");
            this.description = new TextArea("portaldesc");
            this.description.setIdAttr("editpropdescription");
            try {
                this.description.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PortalSite psite;
                        PageState s = e.getPageState();
                        if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                            String n = psite.getMission();
                            TextArea ta = (TextArea)e.getTarget();
                            ta.setValue(s, (Object)n);
                        }
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.add((Component)this.descriptionLabel);
            this.add((Component)this.description);
            this.update = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.update"));
            this.update.setIdAttr("editproptextinput");
            this.cancel = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.cancel.setIdAttr("editproptextcancel");
            this.add((Component)this.update);
            this.add((Component)this.cancel);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PortalSite psite;
            PageState s = e.getPageState();
            if (this.update.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                String pname = (String)this.name.getValue(s);
                psite.setTitle(pname);
                String pdesc = (String)this.description.getValue(s);
                psite.setMission(pdesc);
                psite.save();
            }
            PortalSiteMapPanel.this.clearAllVisibility(s);
            PortalSiteMapPanel.this.propForm.setVisible(s, true);
            PortalSiteMapPanel.this.linkPanel.setVisible(s, true);
            PortalSiteMapPanel.this.vmdPanel.setVisible(s, true);
        }
    }

    public class PropertiesForm
    extends Form {
        private Label nameSelected;
        private Label nameLabel;
        private Label name;
        private Label urlLabel;
        private Label url;
        private Label descriptionLabel;
        private Label description;
        private Label creationDateLabel;
        private Label creationDate;
        private Label statusLabel;
        private Label status;
        private Label membersLabel;
        private List members;
        private Label applications;
        private List apps;
        private ActionLink editlink;

        public PropertiesForm(GridPanel gp) {
            super("propsform", (Container)gp);
            this.nameSelected = new Label("Selected Portal");
            this.nameSelected.setIdAttr("propnameselected");
            this.nameSelected.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        String n = psite.getDisplayName();
                        Label t = (Label)e.getTarget();
                        t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.props").localize(s.getRequest()) + " " + n);
                    }
                }
            });
            this.add((Component)this.nameSelected);
            this.add((Component)new Label(""));
            this.nameLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_name"));
            this.nameLabel.setIdAttr("propnamelabel");
            this.name = new Label("portalname");
            this.name.setIdAttr("propname");
            this.name.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        String n = psite.getDisplayName();
                        Label t = (Label)e.getTarget();
                        t.setLabel(n);
                    }
                }
            });
            this.add((Component)this.nameLabel);
            this.add((Component)this.name);
            this.urlLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_url"));
            this.urlLabel.setIdAttr("propurllabel");
            this.url = new Label("portalurl");
            this.url.setIdAttr("propurl");
            this.url.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        String n = psite.getPath();
                        Label t = (Label)e.getTarget();
                        t.setLabel(n);
                    }
                }
            });
            this.add((Component)this.urlLabel);
            this.add((Component)this.url);
            this.descriptionLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_desc"));
            this.descriptionLabel.setIdAttr("propdescriptionlabel");
            this.description = new Label("portaldesc");
            this.description.setIdAttr("propdescription");
            this.description.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        String n = psite.getMission();
                        Label t = (Label)e.getTarget();
                        t.setLabel(n);
                    }
                }
            });
            this.add((Component)this.descriptionLabel);
            this.add((Component)this.description);
            this.creationDateLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_creation_date"));
            this.creationDateLabel.setIdAttr("propcreationdatelabel");
            this.creationDate = new Label("portalcreation");
            this.creationDate.setIdAttr("propcreationdate");
            this.creationDate.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        Date d = psite.getCreationDate();
                        SimpleDateFormat dft = new SimpleDateFormat();
                        String date = d == null ? "----" : dft.format(d);
                        Label t = (Label)e.getTarget();
                        t.setLabel(date);
                    }
                }
            });
            this.add((Component)this.creationDateLabel);
            this.add((Component)this.creationDate);
            this.statusLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_status"));
            this.statusLabel.setIdAttr("propstatuslabel");
            this.status = new Label("portalstatus");
            this.status.setIdAttr("propstatus");
            this.status.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    PortalSite psite;
                    PageState s = e.getPageState();
                    if (PortalSiteMapPanel.this.m_portalTree.isSelected(s) && (psite = (PortalSite)((Object)PortalSiteMapPanel.this.m_selectedPortalRL.get(s))) != null) {
                        Label t = (Label)e.getTarget();
                        if (psite.isDraft()) {
                            t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.is_draft"));
                        } else if (psite.isArchived()) {
                            Date d = psite.getArchiveDate();
                            SimpleDateFormat dft = new SimpleDateFormat();
                            t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.is_archived").localize(s.getRequest()) + " " + dft.format(d));
                        } else {
                            t.setLabel(GlobalizationUtil.globalize("cw.workspace.ui.admin.is_online"));
                        }
                    }
                }
            });
            this.add((Component)this.statusLabel);
            this.add((Component)this.status);
            this.editlink = new ActionLink("Edit These Properties");
            this.editlink.setIdAttr("propedittheseprops");
            this.editlink.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PageState s = e.getPageState();
                    PortalSiteMapPanel.this.editpropForm.setVisible(s, true);
                    PortalSiteMapPanel.this.propForm.setVisible(s, false);
                    PortalSiteMapPanel.this.linkPanel.setVisible(s, false);
                }
            });
            this.add((Component)this.editlink);
        }
    }

    public class UnarchiveForm
    extends Form
    implements FormProcessListener {
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;

        public UnarchiveForm() {
            super("unarchiveform");
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.online_this_portal"));
            this.button = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.unarchive"));
            this.cancelbutton = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                String id = (String)PortalSiteMapPanel.this.m_portalTree.getSelectedKey(s);
                BigDecimal bd = new BigDecimal(id);
                PortalSite p = PortalSite.retrievePortalSite(bd);
                p.unarchive();
                p.save();
            }
            PortalSiteMapPanel.this.m_portalTree.clearSelection(s);
            this.setVisible(s, false);
            PortalSiteMapPanel.this.m_noPortalSelected.setVisible(s, true);
        }
    }

    public class ArchiveForm
    extends Form
    implements FormProcessListener {
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;
        private RadioGroup radio;
        private String recurse;

        public ArchiveForm() {
            super("archiveform");
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.archive_this_portal"));
            this.button = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.archive"));
            this.cancelbutton = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.radio = new RadioGroup("child_portals");
            this.radio.addOption(new Option("recurse", (Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.recurse_archive"))));
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.add((Component)this.radio);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                this.recurse = (String)this.radio.getValue(s);
                String id = (String)PortalSiteMapPanel.this.m_portalTree.getSelectedKey(s);
                BigDecimal bd = new BigDecimal(id);
                PortalSite p = PortalSite.retrievePortalSite(bd);
                if (this.recurse == null) {
                    p.archive();
                } else {
                    p.archiveRecurse();
                }
                p.save();
            }
            PortalSiteMapPanel.this.m_portalTree.clearSelection(s);
            this.setVisible(s, false);
            PortalSiteMapPanel.this.m_noPortalSelected.setVisible(s, true);
        }
    }
}

