/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ResourceParameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.web.Web;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ForumConfig
extends AbstractConfig {
    private static final Logger s_log = Logger.getLogger(ForumConfig.class);
    private Parameter m_adminEditPosts = new BooleanParameter("com.arsdigita.forum.admin_can_edit_posts", 1, (Object)Boolean.TRUE);
    private Parameter m_authorEditPosts = new BooleanParameter("com.arsdigita.forum.author_can_edit_posts", 1, (Object)Boolean.TRUE);
    private Parameter m_authorDeletePosts = new BooleanParameter("com.arsdigita.forum.author_can_delete_posts", 1, (Object)Boolean.TRUE);
    private Parameter m_digestUserEmail;
    private Parameter m_replyHostName = new StringParameter("com.arsdigita.forum.reply_host_name", 0, null);
    private Parameter m_disablePageCaching;
    private Parameter m_adminOnlyCreateTopics;
    private Parameter m_maxImageSize;
    private Parameter m_maxFileSize;
    private final Parameter m_adapters;
    private Parameter m_showAllThreadAlerts;
    private Parameter m_showNewTabs;
    private Parameter m_useWysiwygEditor;
    private Parameter m_rejectionMessage;
    private Parameter m_threadPageSize;
    private Parameter m_threadOrderField;
    private Parameter m_threadOrderDir;
    private Parameter m_quickFinish;
    private Parameter m_deleteSentSubscriptionNotifications;

    public ForumConfig() {
        this.m_digestUserEmail = new StringParameter("com.arsdigita.forum.digest_user_email", 0, null);
        this.m_disablePageCaching = new BooleanParameter("com.arsdigita.forum.disable_page_caching", 1, (Object)Boolean.FALSE);
        this.m_adminOnlyCreateTopics = new BooleanParameter("com.arsdigita.forum.admin_only_to_create_topics", 1, (Object)Boolean.FALSE);
        this.m_maxImageSize = new IntegerParameter("com.arsdigita.forum.maximum_image_size", 0, null);
        this.m_maxFileSize = new IntegerParameter("com.arsdigita.forum.maximum_file_size", 0, null);
        this.m_showNewTabs = new BooleanParameter("com.arsdigita.forum.show_new_tabs", 0, (Object)Boolean.TRUE);
        this.m_showAllThreadAlerts = new BooleanParameter("com.arsdigita.forum.show_all_forum_thread_alerts", 0, (Object)Boolean.TRUE);
        this.m_useWysiwygEditor = new BooleanParameter("com.arsdigita.forum.use_wysiwyg_editor", 0, (Object)Boolean.FALSE);
        this.m_rejectionMessage = new StringParameter("com.arsdigita.forum.rejection_form_message.example", 0, null);
        this.m_threadPageSize = new IntegerParameter("com.arsdigita.forum.thread_page_size", 1, (Object)new Integer(10));
        this.m_threadOrderField = new StringParameter("com.arsdigita.forum.thread_order_field", 1, (Object)new String("lastUpdate"));
        this.m_threadOrderDir = new StringParameter("com.arsdigita.forum.thread_order_dir", 1, (Object)new String("desc"));
        this.m_quickFinish = new BooleanParameter("com.arsdigita.forum.allow_quick_finish", 0, (Object)Boolean.FALSE);
        this.m_deleteSentSubscriptionNotifications = new BooleanParameter("com.arsdigita.forum.delete_sent_subscription_notifications", 0, (Object)Boolean.FALSE);
        this.m_adapters = new ResourceParameter("com.arsdigita.forum.traversal_adapters", 1, (Object)"/WEB-INF/resources/forum-adapters.xml");
        this.register(this.m_digestUserEmail);
        this.register(this.m_adminEditPosts);
        this.register(this.m_authorEditPosts);
        this.register(this.m_authorDeletePosts);
        this.register(this.m_replyHostName);
        this.register(this.m_adapters);
        this.register(this.m_disablePageCaching);
        this.register(this.m_adminOnlyCreateTopics);
        this.register(this.m_maxImageSize);
        this.register(this.m_maxFileSize);
        this.register(this.m_showAllThreadAlerts);
        this.register(this.m_showNewTabs);
        this.register(this.m_useWysiwygEditor);
        this.register(this.m_rejectionMessage);
        this.register(this.m_threadPageSize);
        this.register(this.m_threadOrderField);
        this.register(this.m_threadOrderDir);
        this.register(this.m_quickFinish);
        this.register(this.m_deleteSentSubscriptionNotifications);
        this.loadInfo();
    }

    InputStream getTraversalAdapters() {
        return (InputStream)this.get(this.m_adapters);
    }

    public boolean canAdminEditPosts() {
        return (Boolean)this.get(this.m_adminEditPosts);
    }

    public boolean canAuthorEditPosts() {
        return (Boolean)this.get(this.m_authorEditPosts);
    }

    boolean canAuthorDeletePosts() {
        return (Boolean)this.get(this.m_authorDeletePosts);
    }

    public String getDigestUserEmail() {
        String email = (String)this.get(this.m_digestUserEmail);
        if (email == null) {
            email = "forum-robot@" + Web.getConfig().getServer().getName();
        }
        return email;
    }

    public String getReplyHostName() {
        String hostName = (String)this.get(this.m_replyHostName);
        if (hostName == null) {
            hostName = Web.getConfig().getServer().getName();
        }
        return hostName;
    }

    public boolean disableClientPageCaching() {
        return (Boolean)this.get(this.m_disablePageCaching);
    }

    public boolean topicCreationByAdminOnly() {
        return (Boolean)this.get(this.m_adminOnlyCreateTopics);
    }

    public User getDigestUser() {
        String email = this.getDigestUserEmail();
        UserCollection users = User.retrieveAll();
        users.addEqualsFilter("primaryEmail", (Object)email);
        if (!users.next()) {
            throw new RuntimeException("cannot find user " + email);
        }
        User user = users.getUser();
        users.close();
        return user;
    }

    public long getMaxImageSize() {
        Integer size = (Integer)this.get(this.m_maxImageSize);
        long longSize = Long.MAX_VALUE;
        if (size != null) {
            longSize = size.longValue();
        }
        return longSize;
    }

    public long getMaxFileSize() {
        Integer size = (Integer)this.get(this.m_maxFileSize);
        long longSize = Long.MAX_VALUE;
        if (size != null) {
            longSize = size.longValue();
        }
        return longSize;
    }

    public boolean showThreadAlertsForAllForums() {
        return (Boolean)this.get(this.m_showAllThreadAlerts);
    }

    public boolean showNewTabs() {
        return (Boolean)this.get(this.m_showNewTabs);
    }

    public boolean useWysiwygEditor() {
        return (Boolean)this.get(this.m_useWysiwygEditor);
    }

    public String getRejectionMessage() {
        return (String)this.get(this.m_rejectionMessage);
    }

    public int getThreadPageSize() {
        return (Integer)this.get(this.m_threadPageSize);
    }

    public String getThreadOrder() {
        String field = (String)this.get(this.m_threadOrderField);
        String dir = (String)this.get(this.m_threadOrderDir);
        if (!field.equals("lastUpdate") && !field.equals("root.sent")) {
            field = "lastUpdate";
        }
        if (!dir.equals("asc") && !dir.equals("desc")) {
            dir = "desc";
        }
        return field + " " + dir;
    }

    public boolean quickFinishAllowed() {
        return (Boolean)this.get(this.m_quickFinish);
    }

    public boolean deleteNotifications() {
        return (Boolean)this.get(this.m_deleteSentSubscriptionNotifications);
    }
}

