/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.forum.DailySubscription;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.forum.PostFileAttachmentURLFinder;
import com.arsdigita.forum.PostFinder;
import com.arsdigita.forum.PostImageAttachment;
import com.arsdigita.forum.RemoveUnattachedAssetsScheduler;
import com.arsdigita.forum.portlet.MyForumsPortlet;
import com.arsdigita.forum.portlet.RecentPostingsPortlet;
import com.arsdigita.forum.search.FileAttachmentMetadataProvider;
import com.arsdigita.forum.search.PostMetadataProvider;
import com.arsdigita.forum.ui.portlet.RecentPostingsPortletEditor;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.ContextCloseEvent;
import com.arsdigita.runtime.ContextInitEvent;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.web.ui.ApplicationConfigFormSection;
import com.arsdigita.xml.XML;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class Initializer
extends CompoundInitializer {
    private static final Logger s_log = Logger.getLogger(Initializer.class);

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-forum.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent e) {
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.Forum", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Forum(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.Post", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Post(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.PostFileAttachment", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PostFileAttachment(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.PostImageAttachment", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PostImageAttachment(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.Inbox", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Forum(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.RecentPostingsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new RecentPostingsPortlet(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.MyForumsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new MyForumsPortlet(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.ForumSubscription", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                if (((Boolean)dataObject.get("isModerationAlert")).booleanValue()) {
                    s_log.debug((Object)"This is a mod alert");
                    return new ModerationAlert(dataObject);
                }
                s_log.debug((Object)"This is a subscription");
                if (dataObject.get("digest") == null) {
                    return new ForumSubscription(dataObject);
                }
                return new DailySubscription(dataObject);
            }
        });
        XML.parse((InputStream)Forum.getConfig().getTraversalAdapters(), (DefaultHandler)new TraversalHandler());
        URLService.registerFinder((String)ThreadedMessage.BASE_DATA_OBJECT_TYPE, (URLFinder)new PostFinder());
        URLService.registerFinder((String)"com.arsdigita.forum.PostFileAttachment", (URLFinder)new PostFileAttachmentURLFinder());
        new ResourceTypeConfig("com.arsdigita.forum.RecentPostingsPortlet"){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                RecentPostingsPortletEditor config = new RecentPostingsPortletEditor(resType, parentAppRL);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                RecentPostingsPortletEditor config = new RecentPostingsPortletEditor(application);
                return config;
            }
        };
        new ResourceTypeConfig("com.arsdigita.forum.Forum", PrivilegeDescriptor.ADMIN, PrivilegeDescriptor.READ){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                ApplicationConfigFormSection config = new ApplicationConfigFormSection(resType, parentAppRL, true);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                ApplicationConfigFormSection config = new ApplicationConfigFormSection(application);
                return config;
            }
        };
        MetadataProviderRegistry.registerAdapter((String)"com.arsdigita.forum.Post", (MetadataProvider)new PostMetadataProvider());
        MetadataProviderRegistry.registerAdapter((String)"com.arsdigita.forum.PostFileAttachment", (MetadataProvider)new FileAttachmentMetadataProvider());
    }

    public void init(ContextInitEvent e) {
        super.init(e);
        if (RuntimeConfig.getConfig().runBackGroundTasks()) {
            RemoveUnattachedAssetsScheduler.startTimer();
        }
    }

    public void close(ContextCloseEvent e) {
        if (RuntimeConfig.getConfig().runBackGroundTasks()) {
            RemoveUnattachedAssetsScheduler.stopTimer();
        }
    }
}

