/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.forum.PostImageAttachment;
import com.arsdigita.forum.RemoveUnattachedAssetsTask;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class RemoveUnattachedAssetsScheduler {
    private static Timer s_Timer;
    private static boolean s_running;
    private static Logger s_log;

    public static synchronized void startTimer() {
        if (s_Timer != null) {
            return;
        }
        s_Timer = new Timer(true);
        s_Timer.scheduleAtFixedRate((TimerTask)new RemoveUnattachedAssetsTask(), 0L, 86400000L);
        s_log.debug((Object)"Background timer process started.");
    }

    public static synchronized void stopTimer() {
        if (s_Timer != null) {
            s_log.debug((Object)"Cancel background timer process, ");
            s_Timer.cancel();
        }
    }

    public static synchronized void run() {
        s_log.debug((Object)"Firing off scheduler");
        Session ssn = SessionManager.getSession();
        if (!s_running) {
            new KernelExcursion(){

                protected final void excurse() {
                    s_running = true;
                    try {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        TransactionContext txn = SessionManager.getSession().getTransactionContext();
                        txn.beginTxn();
                        PostFileAttachment.removeUnattachedFiles();
                        PostImageAttachment.removeUnattachedImages();
                        txn.commitTxn();
                    }
                    catch (Throwable t) {
                        s_log.error((Object)"Attempt to remove unconfirmed forum posts failed", t);
                        throw new UncheckedWrapperException(t);
                    }
                    finally {
                        s_running = false;
                    }
                }
            }.run();
        }
    }

    static {
        s_running = false;
        s_log = Logger.getLogger(RemoveUnattachedAssetsScheduler.class);
    }
}

