/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.FileSizeValidationListener;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.PostImageAttachment;
import com.arsdigita.forum.ui.ConfirmStep;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ImagesTable;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImagesStep
extends FormStep
implements Constants,
FormProcessListener,
FormValidationListener,
FormInitListener {
    private static Logger s_log = Logger.getLogger(ImagesStep.class);
    private ACSObjectSelectionModel m_post;
    private ImagesTable m_images;
    private FileUpload m_upload;
    private TextArea m_description;
    private Submit m_addImage;
    private PostForm m_container;
    private ArrayParameter m_newImages = new ArrayParameter("images");
    private ArrayParameter m_existingImages = new ArrayParameter("oldImages");

    public ImagesStep(ACSObjectSelectionModel post, PostForm container) {
        super("postImages", (Container)new SimpleContainer("forum:postFormImages", "http://www.arsdigita.com/forum/1.0"));
        this.m_post = post;
        this.m_container = container;
        this.m_images = new ImagesTable(this.m_newImages, this.m_existingImages, this);
        this.add((Component)this.m_images);
        this.m_upload = new FileUpload("image", true);
        this.m_upload.addValidationListener((ParameterListener)new NotEmptyValidationListener(Text.gz("forum.ui.validation.image_file_null")){

            public void validate(ParameterEvent e) {
                if (ImagesStep.this.m_addImage.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.m_upload.addValidationListener((ParameterListener)new FileSizeValidationListener(Forum.getConfig().getMaxImageSize()){

            public void validate(ParameterEvent e) {
                if (ImagesStep.this.m_addImage.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.add((Component)this.m_upload);
        this.m_description = new TextArea("imageDescription");
        this.m_description.setCols(20);
        this.m_description.setRows(5);
        this.m_description.addValidationListener((ParameterListener)new NotEmptyValidationListener(Text.gz("forum.ui.validation.image_description_null")){

            public void validate(ParameterEvent e) {
                if (ImagesStep.this.m_addImage.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.m_description.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, 4000, Text.gz("forum.ui.validation.image_description_too_long")){

            public void validate(ParameterEvent e) throws FormProcessException {
                if (ImagesStep.this.m_addImage.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.add((Component)this.m_description);
        this.m_addImage = new Submit("Add Image");
        this.add((Component)this.m_addImage);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"process event fired");
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        if (this.m_addImage.isSelected(state)) {
            s_log.debug((Object)"adding file");
            try {
                String fileName = (String)this.m_upload.getValue(state);
                s_log.debug((Object)("filename is " + fileName));
                File file = ((MultipartHttpServletRequest)e.getPageState().getRequest()).getFile(this.m_upload.getName());
                s_log.debug((Object)("uploaded file is " + file.getName()));
                MimeType mimeType = MimeType.guessMimeTypeFromFile((String)fileName);
                s_log.debug((Object)("Upload mime type is instance of " + mimeType.getClass()));
                s_log.debug((Object)("mime type is " + (mimeType == null ? null : mimeType.getMimeType())));
                PostImageAttachment a = new PostImageAttachment();
                a.loadFromFile(fileName, file, null);
                a.setDescription((String)this.m_description.getValue(state));
                a.setMimeType(mimeType);
                BigDecimal id = a.getID();
                String[] current = (String[])state.getValue((ParameterModel)this.m_newImages);
                if (current == null) {
                    current = new String[]{id.toString()};
                } else {
                    List<String> images = Arrays.asList(current);
                    current = new String[images.size() + 1];
                    Iterator<String> it = images.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        current[i++] = it.next();
                    }
                    current[i] = id.toString();
                }
                state.setValue((ParameterModel)this.m_newImages, (Object)current);
                s_log.debug((Object)"File Uploaded");
                this.m_description.setValue(state, null);
            }
            catch (Exception ex) {
                throw new FormProcessException((Throwable)ex);
            }
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (!this.m_addImage.isSelected(state) && StringUtils.isNotBlank((String)((String)this.m_upload.getValue(state)))) {
            throw new FormProcessException((String)Text.gz("forum.ui.validation.image_not_uploaded").localize());
        }
    }

    public void attachImages(Post post, PageState state) {
        PostImageAttachment image;
        String[] existing;
        ArrayList<String> newImages = Collections.EMPTY_LIST;
        String[] newImagesArray = (String[])state.getValue((ParameterModel)this.m_newImages);
        if (newImagesArray != null) {
            newImages = new ArrayList<String>(Arrays.asList(newImagesArray));
        }
        if ((existing = (String[])state.getValue((ParameterModel)this.m_existingImages)) != null) {
            for (int i = 0; i < existing.length; ++i) {
                if (newImages.contains(existing[i])) {
                    newImages.remove(existing[i]);
                    continue;
                }
                image = new PostImageAttachment(new BigDecimal(existing[i]));
                post.removeImage(image);
            }
        }
        Iterator it = newImages.iterator();
        while (it.hasNext()) {
            image = new PostImageAttachment(new BigDecimal((String)it.next()));
            post.addImage(image);
        }
        state.setValue((ParameterModel)this.m_newImages, null);
        state.setValue((ParameterModel)this.m_existingImages, null);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_existingImages);
        p.addGlobalStateParam((ParameterModel)this.m_newImages);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        Post editPost;
        DataAssociationCursor files;
        PageState state = e.getPageState();
        if (this.m_container.getContext(state).equals("edit") && (files = (editPost = (Post)this.m_post.getSelectedObject(state)).getImages()).size() > 0L) {
            String[] fileIDs = new String[new Long(files.size()).intValue()];
            int i = 0;
            while (files.next()) {
                PostImageAttachment image = (PostImageAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
                fileIDs[i++] = image.getID().toString();
            }
            state.setValue((ParameterModel)this.m_existingImages, (Object)fileIDs);
            state.setValue((ParameterModel)this.m_newImages, (Object)fileIDs);
        }
    }

    public DataCollection getCurrentImages(PageState state) {
        String[] currentArray = (String[])state.getValue((ParameterModel)this.m_newImages);
        if (currentArray != null && currentArray.length != 0) {
            List<String> current = Arrays.asList((String[])state.getValue((ParameterModel)this.m_newImages));
            DataCollection images = SessionManager.getSession().retrieve("com.arsdigita.forum.PostImageAttachment");
            images.addFilter("id in :files").set("files", current);
            return images;
        }
        return null;
    }

    public void generatePostXML(PageState state, Element p) {
        DataCollection files = this.getCurrentImages(state);
        if (files == null) {
            return;
        }
        while (files.next()) {
            PostImageAttachment image = (PostImageAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(p.newChildElement("images"));
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)image, ConfirmStep.class.getName());
        }
    }

    protected void clearParameters(PageState state) {
        state.setValue((ParameterModel)this.m_existingImages, null);
        state.setValue((ParameterModel)this.m_newImages, null);
    }
}

