/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.categorization.Category;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.security.UserContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TopicAddForm
extends Form {
    private static final Logger s_log = Logger.getLogger(TopicAddForm.class);
    private TextField m_name;
    private TextArea m_description;

    public TopicAddForm() {
        super("categoryAdd");
        this.setRedirecting(true);
        this.add((Component)new Label(Text.gz("forum.ui.topic.name")));
        this.m_name = new TextField("name");
        this.m_name.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_name);
        this.add((Component)new Label(Text.gz("forum.ui.topic.description")));
        this.m_description = new TextArea("description");
        this.m_description.setRows(5);
        this.m_description.setCols(60);
        this.m_description.setWrap(2);
        this.add((Component)this.m_description);
        Submit submit = new Submit(Text.gz("forum.ui.topic.save"));
        final Submit cancel = new Submit(Text.gz("forum.ui.cancel"));
        this.add((Component)submit);
        this.add((Component)cancel);
        this.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (cancel.isSelected(state)) {
                    TopicAddForm.this.fireCompletionEvent(state);
                    throw new FormProcessException("cancelled");
                }
            }
        });
        this.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) {
                PageState state = e.getPageState();
                Forum forum = ForumContext.getContext(state).getForum();
                String name = (String)TopicAddForm.this.m_name.getValue(state);
                String description = (String)TopicAddForm.this.m_description.getValue(state);
                Category topic = new Category();
                topic.setName(name);
                topic.setDescription(description);
                topic.save();
                Category parent = forum.getRootCategory();
                parent.addChild((ACSObject)topic);
                parent.save();
                topic.setDefaultParentCategory(parent);
                topic.save();
                TopicAddForm.this.fireCompletionEvent(state);
            }
        });
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                PageState state = e.getPageState();
                FormData data = e.getFormData();
                if (Kernel.getContext().getParty() == null) {
                    UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
                }
            }
        });
    }
}

