/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

public class TopicSelector
extends SimpleComponent
implements Constants {
    public void generateXML(PageState state, Element parent) {
        Element content = parent.newChildElement("forum:topicSelector", "http://www.arsdigita.com/forum/1.0");
        URL url = URL.request((HttpServletRequest)state.getRequest(), null);
        BigDecimal id = ForumContext.getContext(state).getCategorySelection();
        if (id != null) {
            content.addAttribute("currentTopicID", id.toString());
        }
        content.addAttribute("baseURL", url.toString());
        content.addAttribute("param", "topic");
        content.addAttribute("anyTopicID", TOPIC_ANY.toString());
        content.addAttribute("noTopicID", TOPIC_NONE.toString());
        Forum forum = ForumContext.getContext(state).getForum();
        DataAssociationCursor cursor = forum.getFilledCategories();
        while (cursor.next()) {
            Category c = new Category(cursor.getDataObject());
            Element topicEl = content.newChildElement("forum:topic", "http://www.arsdigita.com/forum/1.0");
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(topicEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)c, TopicSelector.class.getName());
        }
    }
}

