/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.persistence.DataQuery;
import java.math.BigDecimal;
import javax.servlet.ServletException;

public abstract class MembersDisplay
extends SimpleContainer {
    private MembersDisplay m_membersDisplay;
    private List m_users = new List(){

        public void respond(PageState ps) throws ServletException {
            super.respond(ps);
            BigDecimal userID = new BigDecimal(ps.getControlEventValue());
            MembersDisplay.this.removeUser(ps, userID);
        }
    };

    public MembersDisplay() {
        this.m_users.setModelBuilder((ListModelBuilder)new UserListModelBuilder());
        this.m_users.setCellRenderer((ListCellRenderer)new UserListCellRenderer());
        this.m_users.setEmptyView((Component)new Label("There are no assigned users / groups"));
        this.add((Component)this.m_users);
        this.m_membersDisplay = this;
    }

    public void setClassAttr(String value) {
        this.m_users.setClassAttr(value);
    }

    public void setIdAttr(String value) {
        this.m_users.setIdAttr(value);
    }

    protected abstract DataQuery getUsers(PageState var1);

    protected abstract String getDisplayName(DataQuery var1);

    protected abstract String getKey(DataQuery var1);

    protected abstract void removeUser(PageState var1, BigDecimal var2);

    private class UserListCellRenderer
    implements ListCellRenderer {
        private UserListCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            SimpleContainer c = new SimpleContainer();
            c.add((Component)new Label(value.toString() + " ["));
            c.add((Component)new ControlLink("delete"));
            c.add((Component)new Label("]"));
            return c;
        }
    }

    private class UserListModelBuilder
    implements ListModelBuilder {
        private boolean m_locked = false;

        private UserListModelBuilder() {
        }

        public boolean isLocked() {
            return this.m_locked;
        }

        public void lock() {
            this.m_locked = true;
        }

        public ListModel makeModel(List l, PageState ps) {
            final DataQuery members = MembersDisplay.this.getUsers(ps);
            return new ListModel(){

                public Object getElement() {
                    return MembersDisplay.this.m_membersDisplay.getDisplayName(members);
                }

                public String getKey() {
                    return MembersDisplay.this.m_membersDisplay.getKey(members);
                }

                public boolean next() {
                    return members.next();
                }
            };
        }
    }
}

