/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bundle;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.role.RoleFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.RoleCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.importer.Parser;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringArrayParameter;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);
    private Parameter m_customApplicationInstances = new StringArrayParameter("com.arsdigita.bundle.loader.custom_app_instances", 0, null);
    private Parameter m_categoryFiles = new StringArrayParameter("com.arsdigita.bundle.loader.category_files", 1, (Object)new String[]{"bundle/categories/gen-nav-domain-1.00.xml", "bundle/categories/gen-nav-hierarchy-1.00.xml"});
    private Parameter m_domainMappings = new StringArrayParameter("com.arsdigita.bundle.loader.domain_mappings", 1, (Object)new String[]{"STD-NAV:/navigation/", "STD-NAV:/content/", "STD-NAV:/portal/"});

    public Loader() {
        this.register(this.m_customApplicationInstances);
        this.register(this.m_categoryFiles);
        this.register(this.m_domainMappings);
    }

    public void run(ScriptContext ctx) {
        String[] customApplicationInstances = (String[])this.get(this.m_customApplicationInstances);
        if (customApplicationInstances != null) {
            for (int i = 0; i < customApplicationInstances.length; ++i) {
                String aCustomApplicationInstance = customApplicationInstances[i];
                StringTokenizer tok = new StringTokenizer(aCustomApplicationInstance, ":");
                String type = null;
                String url = null;
                String title = null;
                String parent = null;
                int j = 0;
                while (tok.hasMoreTokens()) {
                    if (0 == j) {
                        type = tok.nextToken();
                    } else if (1 == j) {
                        url = tok.nextToken();
                    } else if (2 == j) {
                        title = tok.nextToken();
                    } else {
                        parent = 3 == j ? tok.nextToken() : null;
                    }
                    ++j;
                }
                Application.createApplication(type, url, title, null);
            }
        }
        String[] files = (String[])this.get(this.m_categoryFiles);
        Parser parser = new Parser();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Process " + file));
            }
            parser.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(file));
        }
        String[] domainMappings = (String[])this.get(this.m_domainMappings);
        for (int i = 0; i < domainMappings.length; ++i) {
            String aDomainMapping = domainMappings[i];
            StringTokenizer tok = new StringTokenizer(aDomainMapping, ":");
            String key = null;
            String app = null;
            String context = null;
            int j = 0;
            while (tok.hasMoreTokens()) {
                if (0 == j) {
                    key = tok.nextToken();
                } else if (1 == j) {
                    app = tok.nextToken();
                } else {
                    context = 2 == j ? tok.nextToken() : null;
                }
                ++j;
            }
            this.registerDomain(key, app, context);
        }
    }

    public void registerDomain(String domainKey, String appURL, String context) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Mapping domain " + domainKey + " to app " + appURL + " in context " + context));
        }
        Domain domain = Domain.retrieve((String)domainKey);
        Application app = Application.retrieveApplicationForPath((String)appURL);
        domain.setAsRootForObject((ACSObject)app, context);
        if (app instanceof ContentSection) {
            RoleCollection coll = ((ContentSection)app).getStaffGroup().getOrderedRoles();
            HashSet<Role> adminRoles = new HashSet<Role>();
            HashSet<Role> categorizeRoles = new HashSet<Role>();
            while (coll.next()) {
                Role role = coll.getRole();
                DataQuery privs = RoleFactory.getRolePrivileges((BigDecimal)app.getID(), (BigDecimal)role.getGroup().getID());
                while (privs.next()) {
                    String priv = (String)privs.get("privilege");
                    if (priv.equals("cms_category_admin")) {
                        adminRoles.add(role);
                        continue;
                    }
                    if (!priv.equals("cms_categorize_items")) continue;
                    categorizeRoles.add(role);
                }
            }
            RootCategoryCollection catCollection = Category.getRootCategories((ACSObject)((ContentSection)app));
            while (catCollection.next()) {
                Iterator adminIter = adminRoles.iterator();
                while (adminIter.hasNext()) {
                    ((Role)adminIter.next()).grantPermission((ACSObject)catCollection.getCategory(), PrivilegeDescriptor.ADMIN);
                }
                Iterator categorizeIter = categorizeRoles.iterator();
                while (categorizeIter.hasNext()) {
                    ((Role)categorizeIter.next()).grantPermission((ACSObject)catCollection.getCategory(), Category.MAP_DESCRIPTOR);
                }
            }
        }
    }
}

