/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bundle;

import com.arsdigita.bundle.ObjectTypeTraversal;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Stack;
import org.apache.log4j.Logger;

public class ObjectTypeSchemaGenerator
extends ObjectTypeTraversal {
    private static final Logger logger = Logger.getLogger(ObjectTypeSchemaGenerator.class);
    private boolean m_wrapRoot = false;
    private boolean m_wrapObjects = false;
    private boolean m_wrapAttributes = false;
    private Stack m_history = new Stack();
    private HashMap m_elements = new HashMap();
    private Element m_element;
    private Element m_type;
    private Element m_sequence;
    private Property m_property;
    private Stack m_properties = new Stack();
    private Element m_root = new Element("xs:schema", "http://www.w3.org/2001/XMLSchema");
    private String m_rootName;
    public static final String SCHEMA_PREFIX = "xs:";
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static HashMap s_types = new HashMap();

    protected static String lookupType(Class klass) {
        if (s_types.containsKey(klass)) {
            return (String)s_types.get(klass);
        }
        return "xs:string";
    }

    public static void registerType(Class klass, String type) {
        s_types.put(klass, type);
    }

    public ObjectTypeSchemaGenerator(String rootName, String namespace) {
        this.m_rootName = rootName;
        this.m_root.addAttribute("targetNamespace", namespace);
        this.m_root.addAttribute("xmlns", namespace);
        this.m_root.addAttribute("elementFormDefault", "qualified");
    }

    public Element getRoot() {
        return this.m_root;
    }

    public void setWrapRoot(boolean value) {
        this.m_wrapRoot = value;
    }

    public void setWrapObjects(boolean value) {
        this.m_wrapObjects = value;
    }

    public void setWrapAttributes(boolean value) {
        this.m_wrapAttributes = value;
    }

    @Override
    protected void beginObject(ObjectType obj, String path) {
        String name;
        Element parent;
        Element type;
        Element element;
        if (this.m_type != null && this.m_sequence == null) {
            Element sequence;
            this.m_sequence = sequence = this.m_type.newChildElement("xs:sequence", SCHEMA_NS);
        }
        if (this.m_element == null) {
            if (this.m_wrapRoot) {
                Element sequence;
                element = this.m_root.newChildElement("xs:element", SCHEMA_NS);
                element.addAttribute("name", this.m_rootName);
                type = element.newChildElement("xs:complexType", SCHEMA_NS);
                parent = sequence = type.newChildElement("xs:sequence", SCHEMA_NS);
                name = this.nameFromPath(path);
            } else {
                parent = this.m_root;
                name = this.m_rootName;
            }
        } else {
            parent = this.m_sequence;
            name = this.m_wrapObjects ? "object" : this.nameFromPath(path);
        }
        element = parent.newChildElement("xs:element", SCHEMA_NS);
        element.addAttribute("name", name);
        if (this.m_property != null) {
            if (this.m_property.isNullable()) {
                element.addAttribute("minOccurs", "0");
            }
            if (this.m_property.isCollection()) {
                element.addAttribute("maxOccurs", "unbounded");
            }
        }
        type = element.newChildElement("xs:complexType", SCHEMA_NS);
        Element oid = type.newChildElement("xs:attribute", SCHEMA_NS);
        oid.addAttribute("name", "oid");
        oid.addAttribute("type", "xs:string");
        this.m_elements.put(path, element);
        this.m_history.push(new Element[]{this.m_element, this.m_type, this.m_sequence});
        this.m_element = element;
        this.m_type = type;
        this.m_sequence = null;
    }

    @Override
    protected void endObject(ObjectType obj, String path) {
        Element[] saved = (Element[])this.m_history.pop();
        this.m_element = saved[0];
        this.m_type = saved[1];
        this.m_sequence = saved[2];
    }

    @Override
    protected void handleAttribute(ObjectType obj, String path, Property property) {
        if (this.m_wrapAttributes) {
            if (this.m_sequence == null) {
                Element sequence;
                this.m_sequence = sequence = this.m_type.newChildElement("xs:sequence", SCHEMA_NS);
            }
            Element element = new Element("xs:element", SCHEMA_NS);
            element.addAttribute("name", property.getName());
            element.addAttribute("type", ObjectTypeSchemaGenerator.lookupType(property.getJavaClass()));
            if (property.isNullable()) {
                element.addAttribute("minOccurs", "0");
            }
            this.m_sequence.addContent(element);
            this.m_elements.put(path, element);
        } else {
            Element element = new Element("xs:attribute", SCHEMA_NS);
            element.addAttribute("name", property.getName());
            element.addAttribute("type", ObjectTypeSchemaGenerator.lookupType(property.getJavaClass()));
            if (property.isRequired()) {
                element.addAttribute("use", "required");
            }
            this.m_type.addContent(element);
            this.m_elements.put(path, element);
        }
    }

    @Override
    protected void beginRole(ObjectType obj, String path, Property property) {
        if (this.m_wrapObjects) {
            if (this.m_sequence == null) {
                Element sequence;
                this.m_sequence = sequence = this.m_type.newChildElement("xs:sequence", SCHEMA_NS);
            }
            Element element = this.m_sequence.newChildElement("xs:element", SCHEMA_NS);
            element.addAttribute("name", property.getName());
            if (property.isNullable()) {
                element.addAttribute("minOccurs", "0");
            }
            Element type = element.newChildElement("xs:complexType", SCHEMA_NS);
            Element sequence = type.newChildElement("xs:sequence", SCHEMA_NS);
            this.m_history.push(new Element[]{this.m_element, this.m_type, this.m_sequence});
            this.m_element = element;
            this.m_type = type;
            this.m_sequence = sequence;
        }
        this.m_properties.push(this.m_property);
        this.m_property = property;
    }

    @Override
    protected void endRole(ObjectType obj, String path, Property property) {
        if (this.m_wrapObjects) {
            Element[] saved = (Element[])this.m_history.pop();
            this.m_element = saved[0];
            this.m_type = saved[1];
            this.m_sequence = saved[2];
        }
        this.m_property = (Property)this.m_properties.pop();
    }

    @Override
    protected void beginAssociation(ObjectType obj, String path, Property property) {
        if (this.m_wrapObjects) {
            if (this.m_sequence == null) {
                Element sequence;
                this.m_sequence = sequence = this.m_type.newChildElement("xs:sequence", SCHEMA_NS);
            }
            Element element = this.m_sequence.newChildElement("xs:element", SCHEMA_NS);
            element.addAttribute("name", property.getName());
            if (property.isNullable()) {
                element.addAttribute("minOccurs", "0");
            }
            Element type = element.newChildElement("xs:complexType", SCHEMA_NS);
            Element sequence = type.newChildElement("xs:sequence", SCHEMA_NS);
            this.m_history.push(new Element[]{this.m_element, this.m_type, this.m_sequence});
            this.m_element = element;
            this.m_type = type;
            this.m_sequence = sequence;
        }
        this.m_properties.push(this.m_property);
        this.m_property = property;
    }

    @Override
    protected void endAssociation(ObjectType obj, String path, Property property) {
        if (this.m_wrapObjects) {
            Element[] saved = (Element[])this.m_history.pop();
            this.m_element = saved[0];
            this.m_type = saved[1];
            this.m_sequence = saved[2];
        }
        this.m_property = (Property)this.m_properties.pop();
    }

    static {
        logger.debug((Object)"Static initalizer starting...");
        s_types.put(String.class, "xs:string");
        s_types.put(Boolean.class, "xs:boolean");
        s_types.put(Integer.class, "xs:integer");
        s_types.put(BigDecimal.class, "xs:double");
        logger.debug((Object)"Static initalizer finished.");
    }
}

