/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bundle;

import com.arsdigita.bundle.ObjectTypeTraversalAdapter;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class ObjectTypeTraversal {
    private static HashMap s_adapters = new HashMap();
    private static final Logger s_log = Logger.getLogger(ObjectTypeTraversal.class);

    public static void registerAdapter(ObjectType type, ObjectTypeTraversalAdapter adapter, String context) {
        s_adapters.put(new AdapterKey(type, context), adapter);
    }

    public static void unregisterAdapter(ObjectType type, String context) {
        s_adapters.remove(new AdapterKey(type, context));
    }

    public static void registerAdapter(String type, ObjectTypeTraversalAdapter adapter, String context) {
        ObjectTypeTraversal.registerAdapter(MetadataRoot.getMetadataRoot().getObjectType(type), adapter, context);
    }

    public static void unregisterAdapter(String type, String context) {
        ObjectTypeTraversal.unregisterAdapter(MetadataRoot.getMetadataRoot().getObjectType(type), context);
    }

    public static ObjectTypeTraversalAdapter lookupAdapter(ObjectType type, String context) {
        return (ObjectTypeTraversalAdapter)s_adapters.get(new AdapterKey(type, context));
    }

    public static ObjectTypeTraversalAdapter findAdapter(ObjectType type, String context) {
        ObjectTypeTraversalAdapter adapter = null;
        while (adapter == null && type != null) {
            adapter = ObjectTypeTraversal.lookupAdapter(type, context);
            type = type.getSupertype();
        }
        return adapter;
    }

    public void walk(String type, String context) {
        this.walk(MetadataRoot.getMetadataRoot().getObjectType(type), context);
    }

    public void walk(ObjectType type, String context) {
        Assert.exists((Object)type, ObjectType.class);
        ObjectTypeTraversalAdapter adapter = ObjectTypeTraversal.findAdapter(type, context);
        Assert.exists((Object)adapter, ObjectTypeTraversalAdapter.class);
        this.walk(adapter, type, "/object");
    }

    private void walk(ObjectTypeTraversalAdapter adapter, ObjectType type, String path) {
        this.beginObject(type, path);
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Walking " + path + " type: " + type.getQualifiedName()));
        }
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            String propName = prop.getName();
            if (!adapter.processProperty(type, this.appendToPath(path, prop.getName()), prop)) {
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("Skipping property " + propName));
                continue;
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Process property " + propName + " type " + prop.getType().getQualifiedName()));
            }
            if (prop.isAttribute()) {
                this.handleAttribute(type, path, prop);
                continue;
            }
            if (!prop.isCollection()) {
                this.beginRole(type, path, prop);
                this.walk(adapter, (ObjectType)prop.getType(), this.appendToPath(path, propName));
                this.endRole(type, path, prop);
                continue;
            }
            this.beginAssociation(type, path, prop);
            Property roleProp = prop.getAssociatedProperty();
            this.walk(adapter, (ObjectType)prop.getType(), this.appendToPath(path, propName));
            this.endAssociation(type, path, prop);
        }
        this.endObject(type, path);
    }

    protected abstract void beginObject(ObjectType var1, String var2);

    protected abstract void endObject(ObjectType var1, String var2);

    protected abstract void handleAttribute(ObjectType var1, String var2, Property var3);

    protected abstract void beginRole(ObjectType var1, String var2, Property var3);

    protected abstract void endRole(ObjectType var1, String var2, Property var3);

    protected abstract void beginAssociation(ObjectType var1, String var2, Property var3);

    protected abstract void endAssociation(ObjectType var1, String var2, Property var3);

    protected String appendToPath(String path, String name) {
        if (path.endsWith("/" + name)) {
            path = path + "+";
        } else if (!path.endsWith("/" + name + "+")) {
            path = path + "/" + name;
        }
        return path;
    }

    protected String nameFromPath(String path) {
        int index = path.lastIndexOf("/");
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Path starts with /");
        if (path.endsWith("+")) {
            return path.substring(index + 1, path.length() - 2);
        }
        return path.substring(index + 1);
    }

    protected String parentFromPath(String path) {
        int index = path.lastIndexOf("/");
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Path starts with /");
        if (index == 0) {
            return null;
        }
        return path.substring(0, index - 1);
    }

    private static class AdapterKey {
        private ObjectType m_type;
        private String m_context;

        public AdapterKey(ObjectType type, String context) {
            this.m_type = type;
            this.m_context = context;
        }

        public boolean equals(Object o) {
            if (o instanceof AdapterKey) {
                AdapterKey k = (AdapterKey)o;
                return k.m_type.equals((Object)this.m_type) && k.m_context.equals(this.m_context);
            }
            return false;
        }

        public int hashCode() {
            return this.m_type.hashCode() + this.m_context.hashCode();
        }
    }
}

